/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.task;

import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.Nonnull;

public class IncompleteTasksMergeCheckConfig {
    static final String MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:incomplete-tasks-merge-check-settings-resources";
    private final PluginSettings pluginSettings;

    public IncompleteTasksMergeCheckConfig(PluginSettingsFactory factory) {
        this.pluginSettings = factory.createSettingsForKey("com.atlassian.bitbucket.server.bitbucket-bundled-hooks");
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.pluginSettings.remove(this.createKey(event.getRepository()));
    }

    public boolean isResolutionRequired(@Nonnull Repository repository) {
        Object resolvePullTasks = this.pluginSettings.get(this.createKey(repository));
        return resolvePullTasks instanceof String && Boolean.parseBoolean((String)resolvePullTasks);
    }

    public void setResolutionRequired(@Nonnull Repository repository, boolean resolutionRequired) {
        this.pluginSettings.put(this.createKey(repository), (Object)Boolean.toString(resolutionRequired));
    }

    private String createKey(Repository repository) {
        return "repo." + repository.getId() + ".requireTasksResolved";
    }
}

