/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.task;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.view.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.plugin.hooks.task.IncompleteTasksMergeCheckConfig;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class IncompleteTasksMergeCheckFormFragment
implements ContextualFormFragment {
    static final String FRAGMENT_TEMPLATE = "views.task.settings.mergeCheck.fragment";
    static final String REQUIRE_PULL_TASKS_RESOLVED_FIELD_KEY = "requirePullRequestTasksResolved";
    static final String REPOSITORY = "repository";
    private final IncompleteTasksMergeCheckConfig config;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public IncompleteTasksMergeCheckFormFragment(IncompleteTasksMergeCheckConfig config, SoyTemplateRenderer soyTemplateRenderer) {
        this.config = config;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public void doView(@Nonnull Appendable appendable, @Nonnull Map<String, Object> context) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(context, "context");
        Repository repository = (Repository)context.get(REPOSITORY);
        boolean requirePullTasksResolved = this.config.isResolutionRequired(repository);
        context.put(REQUIRE_PULL_TASKS_RESOLVED_FIELD_KEY, requirePullTasksResolved);
        this.renderView(appendable, context);
    }

    public void validate(@Nonnull Map<String, String[]> stringMap, @Nonnull ValidationErrors validationErrors, @Nonnull Map<String, Object> stringObjectMap) {
    }

    public void doError(@Nonnull Appendable appendable, @Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Collection<String>> fieldErrors, @Nonnull Map<String, Object> context) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(fieldErrors, "fieldErrors");
        Objects.requireNonNull(context, "context");
        context.put(REQUIRE_PULL_TASKS_RESOLVED_FIELD_KEY, this.isCheckBoxEnabled(requestParams));
        this.renderView(appendable, context);
    }

    public void execute(@Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        Repository repository = (Repository)context.get(REPOSITORY);
        this.config.setResolutionRequired(repository, this.isCheckBoxEnabled(requestParams));
    }

    private void renderView(Appendable appendable, Map<String, Object> context) {
        try {
            this.soyTemplateRenderer.render(appendable, "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:incomplete-tasks-merge-check-settings-resources", FRAGMENT_TEMPLATE, context);
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render views.task.settings.mergeCheck.fragment", (Throwable)e);
        }
    }

    private boolean isCheckBoxEnabled(Map<String, String[]> requestParams) {
        String[] values = requestParams.get(REQUIRE_PULL_TASKS_RESOLVED_FIELD_KEY);
        return values != null && values.length == 1 && values[0].equalsIgnoreCase("on");
    }
}

