/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.task;

import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.stash.internal.plugin.upgrades.MergeCheckToHooksV2MigrationJob;
import java.util.List;

public class IncompleteTasksMergeCheckMigrationJob
implements MergeCheckToHooksV2MigrationJob {
    private final PluginSettings pluginSettings;
    private final RepositoryHookService repositoryHookService;

    public IncompleteTasksMergeCheckMigrationJob(PluginSettingsFactory factory, RepositoryHookService repositoryHookService) {
        this.pluginSettings = factory.createSettingsForKey("com.atlassian.bitbucket.server.bitbucket-bundled-hooks");
        this.repositoryHookService = repositoryHookService;
    }

    @Override
    public void cleanup(List<Integer> repositoryIds) {
        repositoryIds.forEach(repoId -> this.pluginSettings.remove(this.createKey((int)repoId)));
    }

    @Override
    public String getHookName() {
        return "Incomplete Tasks merge check";
    }

    @Override
    public boolean migrate(Repository repository) {
        Object settings = this.pluginSettings.get(this.createKey(repository.getId()));
        if (Boolean.parseBoolean(String.valueOf(settings))) {
            this.repositoryHookService.enable(new EnableRepositoryHookRequest.Builder((Scope)Scopes.repository((Repository)repository), "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:incomplete-tasks-merge-check").build());
            return true;
        }
        return false;
    }

    private String createKey(int repositoryId) {
        return "repo." + repositoryId + ".requireTasksResolved";
    }
}

