/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.task;

import com.atlassian.bitbucket.hook.repository.DisableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragment;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentContext;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IncompleteTasksRestFragment
implements RestFragment {
    private static final String INCOMPLETE_TASKS_KEY = "requiredAllTasksComplete";
    private final I18nService i18nService;
    private final RepositoryHookService repositoryHookService;
    private final SecurityService securityService;

    public IncompleteTasksRestFragment(I18nService i18nService, RepositoryHookService repositoryHookService, SecurityService securityService) {
        this.i18nService = i18nService;
        this.repositoryHookService = repositoryHookService;
        this.securityService = securityService;
    }

    @Nonnull
    public Map<String, Object> execute(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Repository repository = this.getRepository(requestContext).orElseThrow(() -> new IllegalStateException("The requestContext should contain a repository"));
        if ("GET".equals(fragmentContext.getMethod())) {
            return this.doGet(repository);
        }
        if ("POST".equals(fragmentContext.getMethod())) {
            return this.doPost(fragmentContext, repository);
        }
        return ImmutableMap.of((Object)INCOMPLETE_TASKS_KEY, (Object)this.i18nService.getMessage("bitbucket.pull.tasks.rest.method.unsupported", new Object[]{fragmentContext.getMethod()}));
    }

    @Nonnull
    public Map<String, Object> validate(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        if (fragmentContext.getMethod().equals("POST") && fragmentContext.getBodyProperty(INCOMPLETE_TASKS_KEY).isPresent() && !this.getEnabledProperty(fragmentContext).isPresent()) {
            return new RestErrorMessage(INCOMPLETE_TASKS_KEY, this.i18nService.getMessage("bitbucket.pull.tasks.rest.invalid", new Object[0]));
        }
        return ImmutableMap.of();
    }

    private Map<String, Object> doGet(Repository repository) {
        Boolean isEnabled = (Boolean)this.securityService.withPermission(Permission.REPO_ADMIN, "Retrieving whether com.atlassian.bitbucket.server.bitbucket-bundled-hooks:incomplete-tasks-merge-check is enabled").call(() -> {
            RepositoryHook hook = this.repositoryHookService.getByKey((Scope)Scopes.repository((Repository)repository), "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:incomplete-tasks-merge-check");
            return hook != null && hook.isEnabled();
        });
        return ImmutableMap.of((Object)INCOMPLETE_TASKS_KEY, (Object)isEnabled);
    }

    private Map<String, Object> doPost(RestFragmentContext fragmentContext, Repository repository) {
        this.getEnabledProperty(fragmentContext).ifPresent(shouldEnable -> {
            if (shouldEnable.booleanValue()) {
                this.repositoryHookService.enable(new EnableRepositoryHookRequest.Builder((Scope)Scopes.repository((Repository)repository), "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:incomplete-tasks-merge-check").build());
            } else {
                this.repositoryHookService.disable(new DisableRepositoryHookRequest.Builder((Scope)Scopes.repository((Repository)repository), "com.atlassian.bitbucket.server.bitbucket-bundled-hooks:incomplete-tasks-merge-check").build());
            }
        });
        return this.doGet(repository);
    }

    private Optional<Boolean> getEnabledProperty(RestFragmentContext fragmentContext) {
        return fragmentContext.getBodyProperty(INCOMPLETE_TASKS_KEY).filter(Objects::nonNull).filter(value -> value instanceof Boolean).map(isEnabled -> (Boolean)isEnabled);
    }

    private Optional<Repository> getRepository(@Nonnull Map<String, Object> requestContext) {
        Object repository;
        if (requestContext.containsKey("repository") && (repository = requestContext.get("repository")) instanceof Repository) {
            return Optional.of((Repository)repository);
        }
        return Optional.empty();
    }
}

