/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.verifycommitsignature;

import com.atlassian.bitbucket.dmz.signature.verification.SignatureState;
import com.atlassian.bitbucket.idx.CommitPropertyConfiguration;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureCommitPropertyConfiguration
implements CommitPropertyConfiguration {
    @VisibleForTesting
    static final String PROP_SIGNATURE = "signature";
    @VisibleForTesting
    static final Set<String> SIGNATURE_PROPERTIES = ImmutableSet.of((Object)"signature_fingerprint", (Object)"signature_is_system_signed", (Object)"signature_owner", (Object)"signature_state", (Object)"signature_type", (Object)"signature_x509_issuer_cn", (Object[])new String[]{"signature_x509_issuer_o", "signature_x509_issuer_ou", "signature_x509_issuer_ski", "signature_x509_signer_cn", "signature_x509_signer_o", "signature_x509_signer_sha1", "signature_x509_signer_ski"});
    private static final Logger log = LoggerFactory.getLogger(SignatureCommitPropertyConfiguration.class);
    private final FeatureManager featureManager;

    public SignatureCommitPropertyConfiguration(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Nonnull
    public Collection<String> getPropertiesToPreload(Repository repository) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.COMMIT_SHOW_SIGNATURES)) {
            return Collections.emptyList();
        }
        return SIGNATURE_PROPERTIES;
    }

    @Nonnull
    public Map<String, Map<String, Object>> processProperties(@Nonnull Map<String, Map<String, Object>> commitIdToProperties) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.COMMIT_SHOW_SIGNATURES)) {
            return Collections.emptyMap();
        }
        return (Map)commitIdToProperties.entrySet().stream().collect(MoreCollectors.toImmutableMap(Map.Entry::getKey, entry -> this.combineProperties((String)entry.getKey(), (Map)entry.getValue())));
    }

    private static String formatFingerprint(String fingerprint) {
        if (StringUtils.isBlank((CharSequence)fingerprint) || fingerprint.length() < 16) {
            return "";
        }
        Iterable groups = Splitter.fixedLength((int)4).split((CharSequence)fingerprint.substring(fingerprint.length() - 16));
        return Joiner.on((String)" ").join(groups).toUpperCase();
    }

    private static String getFirstValueOf(String commitId, Map<String, Object> properties, String key) {
        Set values = (Set)properties.get(key);
        if (values == null || values.isEmpty()) {
            log.debug("[{}] Expected a value for {} but got a null instead. Commit may be in the process of being indexed.", (Object)commitId, (Object)key);
            return "";
        }
        return (String)Iterables.getFirst((Iterable)values, (Object)"");
    }

    private Map<String, Object> combineProperties(String commitId, Map<String, Object> properties) {
        Map<String, Object> signatureProperties = this.signaturePropertiesFrom(commitId, properties);
        if (!signatureProperties.isEmpty()) {
            return Collections.singletonMap(PROP_SIGNATURE, signatureProperties);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> signaturePropertiesFrom(String commitId, Map<String, Object> properties) {
        String isSystemSigned;
        if (!properties.containsKey("signature_state")) {
            return Collections.emptyMap();
        }
        String signatureType = SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_type");
        if ("X509".equals(signatureType) && this.featureManager.isDisabled((Feature)StandardFeature.X509_CERTIFICATE_SIGNING)) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String state = SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_state");
        builder.put((Object)"isVerified", (Object)SignatureState.fromCode((char)state.charAt(0)).isVerified());
        if (properties.containsKey("signature_owner")) {
            builder.put((Object)"owner", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_owner"));
        }
        if (properties.containsKey("signature_is_system_signed") && !(isSystemSigned = SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_is_system_signed")).isEmpty()) {
            builder.put((Object)"isSystemSigned", (Object)isSystemSigned);
        }
        switch (signatureType) {
            case "GPG": {
                builder.put((Object)"fingerprint", (Object)SignatureCommitPropertyConfiguration.formatFingerprint(SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_fingerprint")));
                break;
            }
            case "SSH": {
                builder.put((Object)"fingerprint", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_fingerprint"));
                break;
            }
            case "X509": {
                builder.put((Object)"issuerCN", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_x509_issuer_cn"));
                builder.put((Object)"issuerO", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_x509_issuer_o"));
                builder.put((Object)"issuerOU", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_x509_issuer_ou"));
                builder.put((Object)"issuerSKI", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_x509_issuer_ski"));
                builder.put((Object)"signerCN", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_x509_signer_cn"));
                builder.put((Object)"signerO", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_x509_signer_o"));
                builder.put((Object)"signerSHA1", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_x509_signer_sha1"));
                builder.put((Object)"signerSKI", (Object)SignatureCommitPropertyConfiguration.getFirstValueOf(commitId, properties, "signature_x509_signer_ski"));
                break;
            }
            default: {
                log.debug("Invalid signature type: {} for commit ID: {}", (Object)signatureType, (Object)commitId);
                return Collections.emptyMap();
            }
        }
        builder.put((Object)"type", (Object)signatureType);
        return builder.build();
    }
}

