/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.verifycommitsignature;

import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationResult;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifier;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifierFactory;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifierFactoryModuleDescriptor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmExtendedCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.signed.SignableObjectType;
import com.atlassian.bitbucket.scm.signed.SignedObjectCallback;
import com.atlassian.bitbucket.scm.signed.SignedObjectsParameters;
import com.atlassian.bitbucket.scm.signed.StandardSignableObjectType;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.plugin.hooks.verifycommitsignature.VerifyingSignedObjectCallback;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureVerificationHelper {
    private static final Logger log = LoggerFactory.getLogger(SignatureVerificationHelper.class);
    private final PluginAccessor pluginAccessor;
    private final ScmService scmService;

    public SignatureVerificationHelper(ScmService scmService, PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.scmService = scmService;
    }

    public SignedObjectsCallControl runSignedObjects(Repository repository) {
        List<SignatureVerifier> signatureVerifiers = this.getSignatureVerifiers();
        ScmExtendedCommandFactory commandFactory = this.scmService.getExtendedCommandFactory(repository);
        VerifyingSignedObjectCallback callback = new VerifyingSignedObjectCallback(signatureVerifiers);
        SignedObjectsParameters request = new SignedObjectsParameters.Builder().objectIdSource(callback.getObjectIdSource()).build();
        Future future = commandFactory.signedObjects(request, (SignedObjectCallback)callback).asynchronous().start();
        return new SignedObjectsCallControl(future, callback);
    }

    private List<SignatureVerifier> getSignatureVerifiers() {
        return (List)ModuleDescriptorUtils.toModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(SignatureVerifierFactoryModuleDescriptor.class)).map(SignatureVerifierFactory::createSignatureVerifier).filter(Optional::isPresent).map(Optional::get).collect(MoreCollectors.toImmutableList());
    }

    public static class SignedObjectsCallControl
    implements AutoCloseable {
        private final VerifyingSignedObjectCallback callback;
        private final Future future;

        public SignedObjectsCallControl(Future future, VerifyingSignedObjectCallback callback) {
            this.future = future;
            this.callback = callback;
        }

        public Optional<SignatureVerificationResult> verify(StandardSignableObjectType objectType, String objectId, Date objectTimestamp) {
            try {
                return this.callback.verify((SignableObjectType)objectType, objectId, objectTimestamp);
            }
            catch (IllegalStateException e) {
                log.debug("signedObjects command " + e.getMessage());
                return Optional.empty();
            }
        }

        @Override
        public void close() {
            try {
                this.callback.complete();
                this.future.get(5L, TimeUnit.SECONDS);
            }
            catch (CancellationException e) {
                log.debug("signedObjects command was canceled");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.future.cancel(true);
            }
            catch (ExecutionException e) {
                log.warn("signedObjects command failed", e.getCause());
            }
            catch (TimeoutException e) {
                log.debug("signedObjects command did not finish; canceling");
                this.future.cancel(true);
            }
        }
    }
}

