/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.verifycommitsignature;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureState;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationPublicKey;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationResult;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.CommitIndexer;
import com.atlassian.bitbucket.idx.IndexingContext;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.signed.StandardSignableObjectType;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.plugin.hooks.verifycommitsignature.SignatureVerificationHelper;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedCommitIndexer
implements CommitIndexer {
    public static final String COMMITS = "commits";
    public static final String IDX_PROP_SIGNATURE_FINGERPRINT = "signature_fingerprint";
    public static final String IDX_PROP_SIGNATURE_IS_SYSTEM_SIGNED = "signature_is_system_signed";
    public static final String IDX_PROP_SIGNATURE_OWNER = "signature_owner";
    public static final String IDX_PROP_SIGNATURE_STATE = "signature_state";
    public static final String IDX_PROP_SIGNATURE_TYPE = "signature_type";
    public static final String IDX_PROP_SIGNATURE_X509_ISSUER_CN = "signature_x509_issuer_cn";
    public static final String IDX_PROP_SIGNATURE_X509_ISSUER_O = "signature_x509_issuer_o";
    public static final String IDX_PROP_SIGNATURE_X509_ISSUER_OU = "signature_x509_issuer_ou";
    public static final String IDX_PROP_SIGNATURE_X509_ISSUER_SKI = "signature_x509_issuer_ski";
    public static final String IDX_PROP_SIGNATURE_X509_SIGNER_CN = "signature_x509_signer_cn";
    public static final String IDX_PROP_SIGNATURE_X509_SIGNER_O = "signature_x509_signer_o";
    public static final String IDX_PROP_SIGNATURE_X509_SIGNER_SHA1 = "signature_x509_signer_sha1";
    public static final String IDX_PROP_SIGNATURE_X509_SIGNER_SKI = "signature_x509_signer_ski";
    static final String ID = "com.atlassian.bitbucket.SignedCommitsIndexer";
    private static final Logger log = LoggerFactory.getLogger(SignedCommitIndexer.class);
    private final int batchSize;
    private final CommitIndex commitIndex;
    private final FeatureManager featureManager;
    private final SignatureVerificationHelper signatureVerificationHelper;

    public SignedCommitIndexer(CommitIndex commitIndex, FeatureManager featureManager, ApplicationPropertiesService propertiesService, SignatureVerificationHelper signatureVerificationHelper) {
        this.commitIndex = commitIndex;
        this.featureManager = featureManager;
        this.signatureVerificationHelper = signatureVerificationHelper;
        this.batchSize = propertiesService.getPluginProperty("plugin.signed-commit.batch-size", 300);
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    public boolean isEnabledForRepository(@Nonnull Repository repository) {
        return this.featureManager.isEnabled((Feature)StandardFeature.COMMIT_SHOW_SIGNATURES);
    }

    public void onAfterIndexing(@Nonnull IndexingContext context) {
        List<SimpleCommitDetails> commits = SignedCommitIndexer.requireCommitList(context);
        if (commits.isEmpty()) {
            return;
        }
        this.verifyAndSaveSignatureProperties(context, commits);
        log.debug("Finished indexing signed commits of {}", (Object)context.getRepository().getName());
    }

    public void onBeforeIndexing(@Nonnull IndexingContext context) {
        context.put(COMMITS, new ArrayList());
        log.debug("Start indexing signed commits of {}", (Object)context.getRepository().getName());
    }

    public void onCommitAdded(@Nonnull Commit commit, @Nonnull IndexingContext context) {
        List<SimpleCommitDetails> commits = SignedCommitIndexer.requireCommitList(context);
        commits.add(new SimpleCommitDetails(commit));
        if (commits.size() >= this.batchSize) {
            log.debug("Reached batch size limit of {} for {} and starting verification process", (Object)this.batchSize, (Object)context.getRepository());
            this.verifyAndSaveSignatureProperties(context, commits);
            commits.clear();
        }
    }

    public void onCommitRemoved(@Nonnull Commit commit, @Nonnull IndexingContext context) {
    }

    private static List<SimpleCommitDetails> requireCommitList(IndexingContext context) {
        List commits = (List)context.get(COMMITS);
        if (commits == null) {
            throw new IllegalStateException("Unable to get commit list from context");
        }
        return commits;
    }

    private void addMetadataProperty(Map<String, String> signatureMetadata, String signatureMetadataProperty, String commitId, String indexPropertyName) {
        String metadataProperty = signatureMetadata.get(signatureMetadataProperty);
        if (StringUtils.isNotBlank((CharSequence)metadataProperty)) {
            this.commitIndex.addProperty(commitId, indexPropertyName, metadataProperty);
        }
    }

    private void includeX509SignatureMetadataProperties(Map<String, String> signatureMetadata, String commitId) {
        this.addMetadataProperty(signatureMetadata, "x509_issuer_ski", commitId, IDX_PROP_SIGNATURE_X509_ISSUER_SKI);
        this.addMetadataProperty(signatureMetadata, "x509_issuer_cn", commitId, IDX_PROP_SIGNATURE_X509_ISSUER_CN);
        this.addMetadataProperty(signatureMetadata, "x509_issuer_ou", commitId, IDX_PROP_SIGNATURE_X509_ISSUER_OU);
        this.addMetadataProperty(signatureMetadata, "x509_issuer_o", commitId, IDX_PROP_SIGNATURE_X509_ISSUER_O);
        this.addMetadataProperty(signatureMetadata, "x509_signer_ski", commitId, IDX_PROP_SIGNATURE_X509_SIGNER_SKI);
        this.addMetadataProperty(signatureMetadata, "x509_signer_cn", commitId, IDX_PROP_SIGNATURE_X509_SIGNER_CN);
        this.addMetadataProperty(signatureMetadata, "x509_signer_o", commitId, IDX_PROP_SIGNATURE_X509_SIGNER_O);
        this.addMetadataProperty(signatureMetadata, "x509_signer_sha1", commitId, IDX_PROP_SIGNATURE_X509_SIGNER_SHA1);
    }

    private void verifyAndSaveSignatureProperties(IndexingContext context, List<SimpleCommitDetails> commits) {
        Repository repository = context.getRepository();
        try (SignatureVerificationHelper.SignedObjectsCallControl signedObjectsCallControl = this.signatureVerificationHelper.runSignedObjects(repository);){
            commits.forEach(commit -> {
                String commitId = commit.getCommitId();
                Optional<SignatureVerificationResult> verificationResult = signedObjectsCallControl.verify(StandardSignableObjectType.COMMIT, commitId, commit.getCommitterTimestamp());
                if (!verificationResult.isPresent()) {
                    log.debug("[{}] Commit {} could not get its signature verified via any provider", (Object)repository, (Object)commitId);
                    return;
                }
                SignatureVerificationResult signatureVerificationResult = verificationResult.get();
                SignatureState signatureState = signatureVerificationResult.getSignatureState();
                log.trace("[{}] Commit {} verified as {} by commit indexer.", new Object[]{repository, commitId, signatureState});
                if (signatureState.equals((Object)SignatureState.SIGNATURE_NOT_FOUND) || signatureState.equals((Object)SignatureState.ERROR)) {
                    return;
                }
                String signatureType = signatureVerificationResult.getSignatureType();
                if (StringUtils.isNotBlank((CharSequence)signatureType) && !this.commitIndex.addProperty(commitId, IDX_PROP_SIGNATURE_TYPE, signatureType)) {
                    return;
                }
                SignatureVerificationPublicKey publicKey = signatureVerificationResult.getVerificationPublicKey();
                if (signatureState.isVerified() && publicKey == null) {
                    log.debug("[{}] Commit {} is verified but does not have a public key. signature details not saved.", (Object)repository, (Object)commitId);
                    return;
                }
                ApplicationUser publicKeyOwner = signatureVerificationResult.getOwner();
                if (publicKeyOwner != null) {
                    this.commitIndex.addProperty(commitId, IDX_PROP_SIGNATURE_OWNER, publicKeyOwner.getName());
                }
                if (publicKey != null) {
                    this.commitIndex.addProperty(commitId, IDX_PROP_SIGNATURE_FINGERPRINT, publicKey.getFingerprint());
                }
                this.commitIndex.addProperty(commitId, IDX_PROP_SIGNATURE_STATE, String.valueOf(signatureState.getCode()));
                Map signatureMetadata = signatureVerificationResult.getSignatureMetadata();
                if (!signatureMetadata.isEmpty()) {
                    if ("X509".equals(signatureType)) {
                        this.includeX509SignatureMetadataProperties(signatureMetadata, commitId);
                    }
                    this.addMetadataProperty(signatureMetadata, "is_system_signed", commitId, IDX_PROP_SIGNATURE_IS_SYSTEM_SIGNED);
                }
            });
        }
        catch (RuntimeException e) {
            log.warn("Could not successfully verify and save commit signature properties", (Throwable)e);
        }
    }

    @VisibleForTesting
    static class SimpleCommitDetails {
        private final String commitId;
        private final Date committerTimestamp;

        SimpleCommitDetails(Commit commit) {
            this.commitId = commit.getId();
            this.committerTimestamp = commit.getCommitterTimestamp();
        }

        public String getCommitId() {
            return this.commitId;
        }

        public Date getCommitterTimestamp() {
            return this.committerTimestamp;
        }
    }
}

