/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.verifycommitsignature;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.dmz.hook.DmzRepositoryHookTrigger;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureState;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationResult;
import com.atlassian.bitbucket.hook.repository.CommitAddedDetails;
import com.atlassian.bitbucket.hook.repository.MergeHookRequest;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.git.command.GitRefCommandFactory;
import com.atlassian.bitbucket.scm.git.hook.GitRepositoryHookTrigger;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTag;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTagCallback;
import com.atlassian.bitbucket.scm.git.ref.GitResolveAnnotatedTagsCommandParameters;
import com.atlassian.bitbucket.scm.signed.StandardSignableObjectType;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.stash.internal.plugin.hooks.verifycommitsignature.SignatureVerificationHelper;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyCommitSignatureHook
implements PreRepositoryHook<RepositoryHookRequest> {
    static final String PREFIX = "bitbucket.plugins.hooks.verifycommitsignature.error.";
    static final String PROP_ALLOW_FILE_EDIT = "plugin.bundled.hooks.allow.file.edit";
    static final String PROP_ALLOW_REBASE = "plugin.bundled.hooks.allow.rebase";
    private static final boolean DEFAULT_ALLOW_FILE_EDIT = true;
    private static final boolean DEFAULT_ALLOW_REBASE = true;
    private static final Logger log = LoggerFactory.getLogger(VerifyCommitSignatureHook.class);
    private final boolean allowFileEdit;
    private final boolean allowRebase;
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final GitRefCommandFactory refCommandFactory;
    private final SignatureVerificationHelper signatureVerificationHelper;

    public VerifyCommitSignatureHook(AuthenticationContext authenticationContext, I18nService i18nService, ApplicationPropertiesService propertiesService, GitRefCommandFactory refCommandFactory, SignatureVerificationHelper signatureVerificationHelper) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.refCommandFactory = refCommandFactory;
        this.signatureVerificationHelper = signatureVerificationHelper;
        this.allowFileEdit = propertiesService.getPluginProperty(PROP_ALLOW_FILE_EDIT, true);
        this.allowRebase = propertiesService.getPluginProperty(PROP_ALLOW_REBASE, true);
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryHookRequest request) {
        if (VerifyCommitSignatureHook.isOnlyDeletes(request)) {
            return RepositoryHookResult.accepted();
        }
        boolean signatureRequired = this.isNormalUser();
        Repository repository = request.getRepository();
        if (StandardRepositoryHookTrigger.FILE_EDIT.equals((Object)request.getTrigger())) {
            if (this.allowFileEdit || !signatureRequired) {
                log.trace("[{}] Skipping commit verification for in-browser edit", (Object)repository);
                return RepositoryHookResult.accepted();
            }
            return VerifyCommitSignatureHook.reject(this.i18nService, "file.edit", new String[0]);
        }
        if (GitRepositoryHookTrigger.REBASE.equals((Object)request.getTrigger()) || VerifyCommitSignatureHook.isRebaseMerge(request)) {
            if (this.allowRebase || !signatureRequired) {
                log.trace("[{}] Skipping commit verification for in-app rebase", (Object)repository);
                return RepositoryHookResult.accepted();
            }
            return VerifyCommitSignatureHook.reject(this.i18nService, "rebase", new String[0]);
        }
        if (DmzRepositoryHookTrigger.MERGE_QUEUE.equals((Object)request.getTrigger())) {
            log.trace("[{}] Skipping commit verification for merge queue commits", (Object)repository);
            return RepositoryHookResult.accepted();
        }
        RepositoryHookResult result = new CommitAnalyzer(request, signatureRequired).maybeVerifyTags();
        if (result.isRejected()) {
            return result;
        }
        context.registerCommitCallback((PreRepositoryHookCommitCallback)new CommitAnalyzer(request, signatureRequired), RepositoryHookCommitFilter.ADDED_TO_REPOSITORY, new RepositoryHookCommitFilter[0]);
        return RepositoryHookResult.accepted();
    }

    private static boolean isOnlyDeletes(RepositoryHookRequest request) {
        Collection refChanges = request.getRefChanges();
        return !refChanges.isEmpty() && refChanges.stream().map(RefChange::getType).allMatch(type -> type == RefChangeType.DELETE);
    }

    private static boolean isRebaseMerge(RepositoryHookRequest request) {
        if (request instanceof MergeHookRequest) {
            MergeHookRequest mergeHookRequest = (MergeHookRequest)request;
            return "git".equals(mergeHookRequest.getRepository().getScmId()) && mergeHookRequest.getStrategyId().map(strategyId -> "rebase-ff-only".equals(strategyId) || "rebase-no-ff".equals(strategyId)).orElse(false) != false;
        }
        return false;
    }

    private RepositoryHookResult checkSignatureState(SignatureState state, String displayId, boolean signatureRequired) {
        switch (state) {
            case GOOD: 
            case GOOD_BUT_OUT_OF_DATE: {
                return RepositoryHookResult.accepted();
            }
            case GOOD_BUT_UNKNOWN_VALIDITY: {
                return VerifyCommitSignatureHook.reject(this.i18nService, "unknown", displayId);
            }
            case GOOD_BUT_REVOKED: {
                return VerifyCommitSignatureHook.reject(this.i18nService, "revoked", displayId);
            }
            case GOOD_BUT_MADE_AFTER_EXPIRY: {
                return VerifyCommitSignatureHook.reject(this.i18nService, "expired", displayId);
            }
            case GOOD_BUT_MADE_BEFORE_VALIDITY: {
                return VerifyCommitSignatureHook.reject(this.i18nService, "before.validity", displayId);
            }
            case BAD: {
                return VerifyCommitSignatureHook.reject(this.i18nService, "bad", displayId);
            }
            case ERROR: {
                return VerifyCommitSignatureHook.reject(this.i18nService, "error", displayId);
            }
            case SIGNATURE_NOT_FOUND: {
                if (signatureRequired) {
                    return VerifyCommitSignatureHook.reject(this.i18nService, "no.signature", displayId);
                }
                return RepositoryHookResult.accepted();
            }
            case PUBLIC_KEY_NOT_FOUND: {
                return VerifyCommitSignatureHook.reject(this.i18nService, "no.key", displayId, Product.NAME);
            }
        }
        return VerifyCommitSignatureHook.reject(this.i18nService, "system", displayId);
    }

    private boolean isNormalUser() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        return user != null && user.getType() == UserType.NORMAL;
    }

    public static RepositoryHookResult reject(I18nService i18nService, String i18nKey, String ... i18nParams) {
        return RepositoryHookResult.rejected((String)i18nService.getMessage("bitbucket.plugins.hooks.verifycommitsignature.error.summary", new Object[0]), (String)i18nService.getMessage(PREFIX + i18nKey, (Object[])i18nParams));
    }

    private class CommitAnalyzer
    implements PreRepositoryHookCommitCallback {
        private final RepositoryHookResult.Builder builder;
        private final RepositoryHookRequest hookRequest;
        private final boolean signatureRequired;
        private SignatureVerificationHelper.SignedObjectsCallControl signedObjectsCallControl;

        CommitAnalyzer(RepositoryHookRequest hookRequest, boolean signatureRequired) {
            this.hookRequest = hookRequest;
            this.signatureRequired = signatureRequired;
            this.builder = new RepositoryHookResult.Builder();
        }

        @Nonnull
        public RepositoryHookResult getResult() {
            return this.builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RepositoryHookResult maybeVerifyTags() {
            List tagsToVerify = (List)this.hookRequest.getRefChanges().stream().filter(this::isTagAddOrUpdate).collect(MoreCollectors.toImmutableList());
            if (tagsToVerify.isEmpty()) {
                return RepositoryHookResult.accepted();
            }
            Repository repository = this.hookRequest.getRepository();
            TagSignatureCallback callback = new TagSignatureCallback(VerifyCommitSignatureHook.this, repository);
            GitResolveAnnotatedTagsCommandParameters params = new GitResolveAnnotatedTagsCommandParameters.Builder().tagIds((Iterable)tagsToVerify.stream().map(RefChange::getToHash).collect(MoreCollectors.toImmutableList())).maxMessageLength(0).build();
            VerifyCommitSignatureHook.this.refCommandFactory.resolveAnnotatedTags(repository, params, (GitAnnotatedTagCallback)callback).call();
            Set<GitAnnotatedTag> annotatedTags = callback.getResult();
            RepositoryHookResult.Builder builder = new RepositoryHookResult.Builder();
            try {
                this.onStart();
                if (annotatedTags.size() != tagsToVerify.size()) {
                    Set refChanges = (Set)tagsToVerify.stream().filter(refChange -> annotatedTags.stream().map(GitAnnotatedTag::getHash).noneMatch(tagHash -> tagHash.equals(refChange.getToHash()))).collect(MoreCollectors.toImmutableSet());
                    log.debug("[{}] Not all the tags that we want to verify the signature of were annotated tags, they could potentially be lightweight tags instead", (Object)repository);
                    for (RefChange refChange2 : refChanges) {
                        this.addVerifiedObject(builder, refChange2.getRef().getDisplayId(), repository, SignatureState.SIGNATURE_NOT_FOUND);
                    }
                }
                for (GitAnnotatedTag annotatedTag : annotatedTags) {
                    Optional<SignatureVerificationResult> verifiedObject;
                    Instant taggerTimestampInstant = annotatedTag.getTaggerTimestamp().orElse(null);
                    Date taggerTimestamp = null;
                    if (taggerTimestampInstant != null) {
                        taggerTimestamp = Date.from(taggerTimestampInstant);
                    }
                    if (!(verifiedObject = this.signedObjectsCallControl.verify(StandardSignableObjectType.TAG, annotatedTag.getHash(), taggerTimestamp)).isPresent()) {
                        RepositoryHookResult repositoryHookResult = VerifyCommitSignatureHook.reject(VerifyCommitSignatureHook.this.i18nService, "system", annotatedTag.getDisplayId());
                        return repositoryHookResult;
                    }
                    this.addVerifiedObject(builder, annotatedTag.getDisplayId(), repository, verifiedObject.get().getSignatureState());
                }
            }
            finally {
                this.onEnd();
            }
            return builder.build();
        }

        public boolean onCommitAdded(@Nonnull CommitAddedDetails commitDetails) {
            if (!commitDetails.isAddedToRepository()) {
                return true;
            }
            Commit commit = commitDetails.getCommit();
            String displayId = commit.getDisplayId();
            Optional<SignatureVerificationResult> verifiedObject = this.signedObjectsCallControl.verify(StandardSignableObjectType.COMMIT, commit.getId(), commit.getCommitterTimestamp());
            if (verifiedObject.isPresent()) {
                log.trace("[{}] Commit {} verified as {}", new Object[]{this.hookRequest.getRepository(), displayId, verifiedObject.get().getSignatureState()});
                this.builder.add(VerifyCommitSignatureHook.this.checkSignatureState(verifiedObject.get().getSignatureState(), displayId, this.signatureRequired && !this.isBitbucketCommit(commit)));
            } else {
                this.builder.add(VerifyCommitSignatureHook.reject(VerifyCommitSignatureHook.this.i18nService, "system", displayId));
            }
            return !this.builder.isRejected();
        }

        public void onEnd() {
            this.signedObjectsCallControl.close();
        }

        public void onStart() {
            this.signedObjectsCallControl = VerifyCommitSignatureHook.this.signatureVerificationHelper.runSignedObjects(this.hookRequest.getRepository());
        }

        private void addVerifiedObject(RepositoryHookResult.Builder builder, String displayId, Repository repository, SignatureState signatureState) {
            log.trace("[{}] Tag {} verified as {}", new Object[]{repository, displayId, signatureState});
            builder.add(VerifyCommitSignatureHook.this.checkSignatureState(signatureState, displayId, this.signatureRequired));
        }

        private boolean isBitbucketCommit(Commit commit) {
            if (this.hookRequest instanceof MergeHookRequest) {
                String mergeHash = ((MergeHookRequest)this.hookRequest).getMergeHash().orElse(null);
                return ShaUtils.hashesMatch((String)commit.getId(), (String)mergeHash);
            }
            return false;
        }

        private boolean isTagAddOrUpdate(RefChange refChange) {
            return refChange.getType() != RefChangeType.DELETE && refChange.getRef().getType() == StandardRefType.TAG;
        }
    }

    private class TagSignatureCallback
    implements GitAnnotatedTagCallback {
        private final ImmutableSet.Builder<GitAnnotatedTag> annotatedTags = ImmutableSet.builder();
        private final Repository repository;

        private TagSignatureCallback(VerifyCommitSignatureHook verifyCommitSignatureHook, Repository repository) {
            this.repository = repository;
        }

        public boolean onMissing(@Nonnull String objectHash) {
            log.warn("[{}] tag {} was not found", (Object)this.repository, (Object)objectHash);
            return true;
        }

        public boolean onTag(@Nonnull GitAnnotatedTag tag) {
            this.annotatedTags.add((Object)tag);
            return true;
        }

        private Set<GitAnnotatedTag> getResult() {
            return this.annotatedTags.build();
        }
    }
}

