/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.verifycommitsignature;

import com.atlassian.bitbucket.dmz.signature.verification.SignatureState;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationRequest;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationResult;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerifier;
import com.atlassian.bitbucket.scm.signed.InteractiveSignedObjectIdSource;
import com.atlassian.bitbucket.scm.signed.SignableObjectType;
import com.atlassian.bitbucket.scm.signed.SignedObjectCallback;
import com.atlassian.bitbucket.scm.signed.SignedObjectIdSource;
import com.atlassian.bitbucket.scm.signed.SignedObjectsContext;
import com.atlassian.bitbucket.scm.signed.SignedObjectsSummary;
import com.atlassian.bitbucket.scm.signed.StandardSignableObjectType;
import com.atlassian.bitbucket.util.MoreStreams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VerifyingSignedObjectCallback
implements SignedObjectCallback {
    protected static final long TIMEOUT = 5L;
    private static final Logger log = LoggerFactory.getLogger(VerifyingSignedObjectCallback.class);
    private final InteractiveSignedObjectIdSource objectIdProvider;
    private final List<SignatureVerifier> signatureVerifiers;
    private final Map<String, ObjectVerificationTask> tasks;

    public VerifyingSignedObjectCallback(List<SignatureVerifier> signatureVerifiers) {
        this.signatureVerifiers = signatureVerifiers;
        this.objectIdProvider = new InteractiveSignedObjectIdSource();
        this.tasks = new ConcurrentHashMap<String, ObjectVerificationTask>();
    }

    void complete() {
        this.objectIdProvider.complete();
    }

    SignedObjectIdSource getObjectIdSource() {
        return this.objectIdProvider;
    }

    public void onEnd(@Nonnull SignedObjectsSummary summary) {
        if (!this.tasks.isEmpty()) {
            log.debug("Never got a response for the following requested objects: [{}]", (Object)StringUtils.join(this.tasks.keySet(), (String)", "));
        }
    }

    public void onMissing(@Nonnull String objectId) {
        ObjectVerificationTask task = this.tasks.remove(objectId);
        if (task != null) {
            task.onMissing();
        } else {
            log.warn("Ignoring unexpected signed object {}", (Object)objectId);
        }
    }

    public void onSigned(@Nonnull SignableObjectType type, @Nonnull String objectId, @Nonnull String signature, @Nonnull String signedContent) {
        ObjectVerificationTask task = this.tasks.remove(objectId);
        if (task != null) {
            task.onSigned(type, signature, signedContent);
        } else {
            log.warn("Ignoring unexpected signed object {}", (Object)objectId);
        }
    }

    public void onStart(@Nonnull SignedObjectsContext context) {
    }

    public void onUnsigned(@Nullable SignableObjectType type, @Nonnull String objectId) {
        ObjectVerificationTask task = this.tasks.remove(objectId);
        if (task != null) {
            task.onUnsigned(type);
        } else {
            log.warn("Ignoring unexpected signed object {}", (Object)objectId);
        }
    }

    public Optional<SignatureVerificationResult> verify(SignableObjectType objectType, String objectId, Date objectTimestamp) {
        ObjectVerificationTask task = new ObjectVerificationTask(objectType, objectId, objectTimestamp);
        this.tasks.put(objectId, task);
        this.objectIdProvider.add(objectId);
        try {
            return (Optional)task.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.warn("Failed to retrieve signature details for {}", (Object)objectId, (Object)e);
        }
        catch (TimeoutException e) {
            log.warn("Timed out waiting for signature details for {}", (Object)objectId);
        }
        return Optional.of(new SignatureVerificationResult.Builder(SignatureState.ERROR).build());
    }

    private class ObjectVerificationTask
    extends CompletableFuture<Optional<SignatureVerificationResult>> {
        private final String objectId;
        private final Date objectTimestamp;
        private final SignableObjectType objectType;

        private ObjectVerificationTask(SignableObjectType objectType, String objectId, Date objectTimestamp) {
            this.objectId = objectId;
            this.objectTimestamp = objectTimestamp;
            this.objectType = objectType;
        }

        void onMissing() {
            log.warn("{} was missing; the signature will not be verified", (Object)this.objectId);
            this.complete(Optional.of(new SignatureVerificationResult.Builder(SignatureState.ERROR).build()));
        }

        void onSigned(@Nonnull SignableObjectType objectType, @Nonnull String signature, @Nonnull String signedContent) {
            if (Objects.requireNonNull(this.objectType, "expectedType") == StandardSignableObjectType.TAG && Objects.requireNonNull(objectType, "objectType") != this.objectType) {
                this.complete(Optional.of(new SignatureVerificationResult.Builder(SignatureState.SIGNATURE_NOT_FOUND).build()));
            } else {
                this.complete(VerifyingSignedObjectCallback.this.signatureVerifiers.stream().flatMap(provider -> MoreStreams.streamOptional((Optional)provider.verifySignature(new SignatureVerificationRequest.Builder(signature, signedContent).objectTimestamp(this.objectTimestamp).build()))).findFirst());
            }
        }

        void onUnsigned(SignableObjectType ignored) {
            this.complete(Optional.of(new SignatureVerificationResult.Builder(SignatureState.SIGNATURE_NOT_FOUND).build()));
        }
    }
}

