/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.hooks.verifycommitter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.hook.repository.CommitAddedDetails;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookCommitCallback;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookCommitFilter;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.git.command.GitRefCommandFactory;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTag;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTagCallback;
import com.atlassian.bitbucket.scm.git.ref.GitResolveAnnotatedTagsCommandParameters;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserType;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyCommitterHook
implements PreRepositoryHook<RepositoryHookRequest> {
    static final String PROP_FALLBACK_NAME_MATCH = "plugin.com.atlassian.bitbucket.bundled.hooks.verifycommitter.fallback.name.match";
    private static final Set<RepositoryHookTrigger> IGNORED_TRIGGERS = ImmutableSet.of((Object)StandardRepositoryHookTrigger.BRANCH_DELETE, (Object)StandardRepositoryHookTrigger.PULL_REQUEST_MERGE, (Object)StandardRepositoryHookTrigger.TAG_DELETE);
    private static final Logger log = LoggerFactory.getLogger(VerifyCommitterHook.class);
    private final AuthenticationContext authenticationContext;
    private final boolean fallbackNameMatch;
    private final GitRefCommandFactory gitRefCommandFactory;
    private final I18nService i18nService;

    public VerifyCommitterHook(AuthenticationContext authenticationContext, GitRefCommandFactory gitRefCommandFactory, I18nService i18nService, ApplicationPropertiesService propertiesService) {
        this.authenticationContext = authenticationContext;
        this.gitRefCommandFactory = gitRefCommandFactory;
        this.i18nService = i18nService;
        this.fallbackNameMatch = propertiesService.getPluginProperty(PROP_FALLBACK_NAME_MATCH, false);
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryHookRequest request) {
        if (IGNORED_TRIGGERS.contains(request.getTrigger())) {
            return RepositoryHookResult.accepted();
        }
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.plugins.hooks.verifycommitter.summary", new Object[0]), (String)this.i18nService.getMessage("bitbucket.plugins.hooks.verifycommitter.anonymousdetails", new Object[0]));
        }
        if (user.getType() == UserType.SERVICE) {
            log.trace("[{}] Not verifying committer for service user '{}'", (Object)request.getRepository(), (Object)user.getSlug());
            return RepositoryHookResult.accepted();
        }
        List<RefChange> relevantRefChanges = request.getRefChanges().stream().filter(this::canIntroduceCommits).collect(Collectors.toList());
        if (!relevantRefChanges.isEmpty()) {
            RepositoryHookResult result = this.verifyAnnotatedTags(request.getRepository(), relevantRefChanges);
            if (result.isRejected()) {
                return result;
            }
            context.registerCommitCallback((PreRepositoryHookCommitCallback)new CommitterVerifyingCommitCallback(this.i18nService, user), RepositoryHookCommitFilter.ADDED_TO_REPOSITORY, new RepositoryHookCommitFilter[0]);
        }
        return RepositoryHookResult.accepted();
    }

    private boolean canIntroduceCommits(RefChange refChange) {
        RefChangeType type = refChange.getType();
        return type == RefChangeType.ADD || type == RefChangeType.UPDATE;
    }

    private boolean isMatch(ApplicationUser user, Person person) {
        String email = user.getEmailAddress();
        return StringUtils.isBlank((CharSequence)email) ? this.fallbackNameMatch && StringUtils.equalsIgnoreCase((CharSequence)person.getName(), (CharSequence)user.getDisplayName()) : StringUtils.equalsAnyIgnoreCase((CharSequence)person.getEmailAddress(), (CharSequence[])new CharSequence[]{email});
    }

    private RepositoryHookResult verifyAnnotatedTags(Repository repository, List<RefChange> relevantRefChanges) {
        if (!"git".equals(repository.getScmId())) {
            return RepositoryHookResult.accepted();
        }
        Set tagsToCheck = relevantRefChanges.stream().filter(refChange -> refChange.getRef().getType() == StandardRefType.TAG).map(RefChange::getToHash).collect(Collectors.toSet());
        if (tagsToCheck.isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        TaggerVerifyingCallback callback = new TaggerVerifyingCallback(repository);
        GitResolveAnnotatedTagsCommandParameters params = new GitResolveAnnotatedTagsCommandParameters.Builder().tagIds(tagsToCheck).maxMessageLength(0).build();
        this.gitRefCommandFactory.resolveAnnotatedTags(repository, params, (GitAnnotatedTagCallback)callback).call();
        return callback.getResult();
    }

    private class CommitterVerifyingCommitCallback
    implements PreRepositoryHookCommitCallback {
        private final I18nService i18nService;
        private final RepositoryHookResult.Builder resultBuilder;
        private final ApplicationUser user;

        private CommitterVerifyingCommitCallback(I18nService i18nService, ApplicationUser user) {
            this.i18nService = i18nService;
            this.user = user;
            this.resultBuilder = new RepositoryHookResult.Builder();
        }

        public boolean onCommitAdded(@Nonnull CommitAddedDetails commitDetails) {
            Commit commit = commitDetails.getCommit();
            Person committer = commit.getCommitter();
            if (commitDetails.isAddedToRepository() && !VerifyCommitterHook.this.isMatch(this.user, committer)) {
                this.resultBuilder.veto(this.i18nService.getMessage("bitbucket.plugins.hooks.verifycommitter.summary", new Object[0]), this.i18nService.getMessage("bitbucket.plugins.hooks.verifycommitter.details", new Object[]{commit.getId(), committer.getName(), committer.getEmailAddress()}));
                return false;
            }
            return true;
        }

        @Nonnull
        public RepositoryHookResult getResult() {
            return this.resultBuilder.build();
        }
    }

    private class TaggerVerifyingCallback
    implements GitAnnotatedTagCallback {
        private final Repository repository;
        private final RepositoryHookResult.Builder resultBuilder;
        private final ApplicationUser user;

        private TaggerVerifyingCallback(Repository repository) {
            this.repository = repository;
            this.resultBuilder = new RepositoryHookResult.Builder();
            this.user = VerifyCommitterHook.this.authenticationContext.getCurrentUser();
        }

        public boolean onMissing(@Nonnull String objectHash) throws IOException {
            log.warn("[{}] tag {} was not found", (Object)this.repository, (Object)objectHash);
            return true;
        }

        public boolean onTag(@Nonnull GitAnnotatedTag tag) throws IOException {
            if (!VerifyCommitterHook.this.isMatch(this.user, tag.getTagger())) {
                Person tagger = tag.getTagger();
                this.resultBuilder.veto(VerifyCommitterHook.this.i18nService.getMessage("bitbucket.plugins.hooks.verifycommitter.tag.summary", new Object[0]), VerifyCommitterHook.this.i18nService.getMessage("bitbucket.plugins.hooks.verifycommitter.tag.details", new Object[]{tag.getId(), tagger.getName(), tagger.getEmailAddress()}));
                return false;
            }
            return true;
        }

        private RepositoryHookResult getResult() {
            return this.resultBuilder.build();
        }
    }
}

