/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.upgrades;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.stash.internal.plugin.upgrades.MergeCheckToHooksV2MigrationJob;
import com.google.common.base.Throwables;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCheckToHooksV2UpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(MergeCheckToHooksV2UpgradeTask.class);
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;
    private final List<MergeCheckToHooksV2MigrationJob> migrationTasks;

    public MergeCheckToHooksV2UpgradeTask(RepositoryService repositoryService, SecurityService securityService, TransactionTemplate transactionTemplate, List<MergeCheckToHooksV2MigrationJob> migrationTasks) {
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.transactionTemplate = transactionTemplate;
        this.migrationTasks = migrationTasks;
    }

    public Collection<Message> doUpgrade() throws Exception {
        for (MergeCheckToHooksV2MigrationJob migrationTask : this.migrationTasks) {
            this.migrateConfig(migrationTask);
        }
        return Collections.emptyList();
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getPluginKey() {
        return "com.atlassian.bitbucket.server.bitbucket-bundled-hooks";
    }

    public String getShortDescription() {
        return "Move all bundled merge check settings from plugin-settings to hook-settings";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateConfig(MergeCheckToHooksV2MigrationJob migrationJob) throws Exception {
        EscalatedSecurityContext withRepoAdmin = this.securityService.withPermission(Permission.REPO_ADMIN, migrationJob.getClass().getName());
        ExecutorService executor = Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)(migrationJob.getClass().getSimpleName() + ".doUpgrade")));
        Future<Integer> future = executor.submit(() -> (Integer)withRepoAdmin.call(() -> this.performMigration(migrationJob)));
        try {
            int enabled = future.get();
            log.info("Enabled {} hook for {} repositories", (Object)migrationJob.getHookName(), (Object)enabled);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), Exception.class);
        }
        finally {
            ExecutorUtils.shutdown((ExecutorService)executor, (long)250L, (TimeUnit)TimeUnit.MILLISECONDS, (long)2L, (TimeUnit)TimeUnit.SECONDS, (Logger)log);
        }
    }

    private int performMigration(MergeCheckToHooksV2MigrationJob migrationJob) {
        int enabled = 0;
        int start = 0;
        while (start != -1) {
            ArrayList<Integer> repositoryIds = new ArrayList<Integer>(100);
            PageRequest pageRequest = PageUtils.newRequest((int)start, (int)100);
            start = (Integer)this.transactionTemplate.execute(() -> {
                Page page = this.repositoryService.findAll(pageRequest);
                List enabledRepositories = (List)page.stream().filter(migrationJob::migrate).peek(repository -> log.debug("Enabled {} hook for {}/{}", new Object[]{migrationJob.getHookName(), repository.getProject().getName(), repository.getSlug()})).map(Repository::getId).collect(MoreCollectors.toImmutableList());
                repositoryIds.addAll(enabledRepositories);
                PageRequest nextRequest = page.getNextPageRequest();
                return nextRequest == null ? -1 : nextRequest.getStart();
            });
            if (repositoryIds.size() > 0) {
                enabled += repositoryIds.size();
                migrationJob.cleanup(repositoryIds);
                log.debug("Removed migrated settings for {} {} hook", (Object)repositoryIds.size(), (Object)migrationJob.getHookName());
            }
            if (start % 1000 != 0) continue;
            log.info("Migrated {} for {} repositories", (Object)migrationJob.getHookName(), (Object)start);
        }
        return enabled;
    }
}

