/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.storage.DeletedShare;
import com.microsoft.azure.management.storage.GetShareExpand;
import com.microsoft.azure.management.storage.ListSharesExpand;
import com.microsoft.azure.management.storage.implementation.FileShareInner;
import com.microsoft.azure.management.storage.implementation.FileShareItemInner;
import com.microsoft.azure.management.storage.implementation.PageImpl1;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FileSharesInner {
    private FileSharesService service;
    private StorageManagementClientImpl client;

    public FileSharesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (FileSharesService)retrofit.create(FileSharesService.class);
        this.client = client;
    }

    public PagedList<FileShareItemInner> list(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<FileShareItemInner>((Page)response.body()){

            public Page<FileShareItemInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileSharesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileShareItemInner>> listAsync(String resourceGroupName, String accountName, ListOperationCallback<FileShareItemInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(String nextPageLink) {
                return FileSharesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileShareItemInner>> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<FileShareItemInner>>, Page<FileShareItemInner>>(){

            public Page<FileShareItemInner> call(ServiceResponse<Page<FileShareItemInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileShareItemInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<FileShareItemInner>>, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(ServiceResponse<Page<FileShareItemInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileSharesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileShareItemInner>>> listSinglePageAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String maxpagesize = null;
        String filter = null;
        ListSharesExpand expand = null;
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), maxpagesize, filter, expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileSharesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<FileShareItemInner> list(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand).toBlocking().single();
        return new PagedList<FileShareItemInner>((Page)response.body()){

            public Page<FileShareItemInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileSharesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileShareItemInner>> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand, ListOperationCallback<FileShareItemInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(String nextPageLink) {
                return FileSharesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileShareItemInner>> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName, maxpagesize, filter, expand).map((Func1)new Func1<ServiceResponse<Page<FileShareItemInner>>, Page<FileShareItemInner>>(){

            public Page<FileShareItemInner> call(ServiceResponse<Page<FileShareItemInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileShareItemInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand) {
        return this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand).concatMap((Func1)new Func1<ServiceResponse<Page<FileShareItemInner>>, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(ServiceResponse<Page<FileShareItemInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileSharesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileShareItemInner>>> listSinglePageAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), maxpagesize, filter, expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileSharesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<FileShareItemInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<FileShareItemInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FileShareInner create(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return (FileShareInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, shareName, fileShare).toBlocking().single()).body());
    }

    public ServiceFuture<FileShareInner> createAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, ServiceCallback<FileShareInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, shareName, fileShare), serviceCallback);
    }

    public Observable<FileShareInner> createAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, shareName, fileShare).map((Func1)new Func1<ServiceResponse<FileShareInner>, FileShareInner>(){

            public FileShareInner call(ServiceResponse<FileShareInner> response) {
                return (FileShareInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileShareInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (shareName == null) {
            throw new IllegalArgumentException("Parameter shareName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (fileShare == null) {
            throw new IllegalArgumentException("Parameter fileShare is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)fileShare));
        return this.service.create(resourceGroupName, accountName, shareName, this.client.subscriptionId(), fileShare, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileShareInner>>>(){

            public Observable<ServiceResponse<FileShareInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileSharesInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileShareInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileShareInner>(){}.getType()).register(201, new TypeToken<FileShareInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FileShareInner update(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return (FileShareInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, shareName, fileShare).toBlocking().single()).body());
    }

    public ServiceFuture<FileShareInner> updateAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, ServiceCallback<FileShareInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, shareName, fileShare), serviceCallback);
    }

    public Observable<FileShareInner> updateAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, shareName, fileShare).map((Func1)new Func1<ServiceResponse<FileShareInner>, FileShareInner>(){

            public FileShareInner call(ServiceResponse<FileShareInner> response) {
                return (FileShareInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileShareInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (shareName == null) {
            throw new IllegalArgumentException("Parameter shareName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (fileShare == null) {
            throw new IllegalArgumentException("Parameter fileShare is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)fileShare));
        return this.service.update(resourceGroupName, accountName, shareName, this.client.subscriptionId(), fileShare, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileShareInner>>>(){

            public Observable<ServiceResponse<FileShareInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileSharesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileShareInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileShareInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FileShareInner get(String resourceGroupName, String accountName, String shareName) {
        return (FileShareInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, shareName).toBlocking().single()).body());
    }

    public ServiceFuture<FileShareInner> getAsync(String resourceGroupName, String accountName, String shareName, ServiceCallback<FileShareInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, shareName), serviceCallback);
    }

    public Observable<FileShareInner> getAsync(String resourceGroupName, String accountName, String shareName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, shareName).map((Func1)new Func1<ServiceResponse<FileShareInner>, FileShareInner>(){

            public FileShareInner call(ServiceResponse<FileShareInner> response) {
                return (FileShareInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileShareInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String shareName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (shareName == null) {
            throw new IllegalArgumentException("Parameter shareName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        GetShareExpand expand = null;
        return this.service.get(resourceGroupName, accountName, shareName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileShareInner>>>(){

            public Observable<ServiceResponse<FileShareInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileSharesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public FileShareInner get(String resourceGroupName, String accountName, String shareName, GetShareExpand expand) {
        return (FileShareInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, shareName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<FileShareInner> getAsync(String resourceGroupName, String accountName, String shareName, GetShareExpand expand, ServiceCallback<FileShareInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, shareName, expand), serviceCallback);
    }

    public Observable<FileShareInner> getAsync(String resourceGroupName, String accountName, String shareName, GetShareExpand expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, shareName, expand).map((Func1)new Func1<ServiceResponse<FileShareInner>, FileShareInner>(){

            public FileShareInner call(ServiceResponse<FileShareInner> response) {
                return (FileShareInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileShareInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String shareName, GetShareExpand expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (shareName == null) {
            throw new IllegalArgumentException("Parameter shareName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, shareName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileShareInner>>>(){

            public Observable<ServiceResponse<FileShareInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileSharesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileShareInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileShareInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName, String shareName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, shareName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String shareName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, shareName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String shareName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, shareName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String shareName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (shareName == null) {
            throw new IllegalArgumentException("Parameter shareName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, accountName, shareName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileSharesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void restore(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion) {
        ((ServiceResponse)this.restoreWithServiceResponseAsync(resourceGroupName, accountName, shareName, deletedShareName, deletedShareVersion).toBlocking().single()).body();
    }

    public ServiceFuture<Void> restoreAsync(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.restoreWithServiceResponseAsync(resourceGroupName, accountName, shareName, deletedShareName, deletedShareVersion), serviceCallback);
    }

    public Observable<Void> restoreAsync(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion) {
        return this.restoreWithServiceResponseAsync(resourceGroupName, accountName, shareName, deletedShareName, deletedShareVersion).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> restoreWithServiceResponseAsync(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (shareName == null) {
            throw new IllegalArgumentException("Parameter shareName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (deletedShareName == null) {
            throw new IllegalArgumentException("Parameter deletedShareName is required and cannot be null.");
        }
        if (deletedShareVersion == null) {
            throw new IllegalArgumentException("Parameter deletedShareVersion is required and cannot be null.");
        }
        DeletedShare deletedShare = new DeletedShare();
        deletedShare.withDeletedShareName(deletedShareName);
        deletedShare.withDeletedShareVersion(deletedShareVersion);
        return this.service.restore(resourceGroupName, accountName, shareName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), deletedShare, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileSharesInner.this.restoreDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> restoreDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileShareItemInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FileShareItemInner>((Page)response.body()){

            public Page<FileShareItemInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileSharesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileShareItemInner>> listNextAsync(String nextPageLink, ServiceFuture<List<FileShareItemInner>> serviceFuture, ListOperationCallback<FileShareItemInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(String nextPageLink) {
                return FileSharesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileShareItemInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FileShareItemInner>>, Page<FileShareItemInner>>(){

            public Page<FileShareItemInner> call(ServiceResponse<Page<FileShareItemInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileShareItemInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FileShareItemInner>>, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(ServiceResponse<Page<FileShareItemInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileSharesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileShareItemInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileShareItemInner>>>>(){

            public Observable<ServiceResponse<Page<FileShareItemInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileSharesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<FileShareItemInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<FileShareItemInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FileSharesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileShares list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$maxpagesize") String var5, @Query(value="$filter") String var6, @Query(value="$expand") ListSharesExpand var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileShares create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="shareName") String var3, @Path(value="subscriptionId") String var4, @Body FileShareInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileShares update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="shareName") String var3, @Path(value="subscriptionId") String var4, @Body FileShareInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileShares get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="shareName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Query(value="$expand") GetShareExpand var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileShares delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="shareName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileShares restore"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}/restore")
        public Observable<Response<ResponseBody>> restore(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="shareName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body DeletedShare var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileShares listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

