/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.storage.ErrorResponseException;
import com.microsoft.azure.management.storage.implementation.ObjectReplicationPolicyInner;
import com.microsoft.azure.management.storage.implementation.PageImpl;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ObjectReplicationPoliciesInner {
    private ObjectReplicationPoliciesService service;
    private StorageManagementClientImpl client;

    public ObjectReplicationPoliciesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (ObjectReplicationPoliciesService)retrofit.create(ObjectReplicationPoliciesService.class);
        this.client = client;
    }

    public List<ObjectReplicationPolicyInner> list(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ObjectReplicationPolicyInner>> listAsync(String resourceGroupName, String accountName, ServiceCallback<List<ObjectReplicationPolicyInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<ObjectReplicationPolicyInner>> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<ObjectReplicationPolicyInner>>, List<ObjectReplicationPolicyInner>>(){

            public List<ObjectReplicationPolicyInner> call(ServiceResponse<List<ObjectReplicationPolicyInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ObjectReplicationPolicyInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ObjectReplicationPolicyInner>>>>(){

            public Observable<ServiceResponse<List<ObjectReplicationPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ObjectReplicationPoliciesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ObjectReplicationPolicyInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ObjectReplicationPolicyInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ObjectReplicationPolicyInner get(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        return (ObjectReplicationPolicyInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId).toBlocking().single()).body());
    }

    public ServiceFuture<ObjectReplicationPolicyInner> getAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, ServiceCallback<ObjectReplicationPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId), serviceCallback);
    }

    public Observable<ObjectReplicationPolicyInner> getAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId).map((Func1)new Func1<ServiceResponse<ObjectReplicationPolicyInner>, ObjectReplicationPolicyInner>(){

            public ObjectReplicationPolicyInner call(ServiceResponse<ObjectReplicationPolicyInner> response) {
                return (ObjectReplicationPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ObjectReplicationPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (objectReplicationPolicyId == null) {
            throw new IllegalArgumentException("Parameter objectReplicationPolicyId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, this.client.subscriptionId(), objectReplicationPolicyId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ObjectReplicationPolicyInner>>>(){

            public Observable<ServiceResponse<ObjectReplicationPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ObjectReplicationPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ObjectReplicationPolicyInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ObjectReplicationPolicyInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ObjectReplicationPolicyInner createOrUpdate(String resourceGroupName, String accountName, String objectReplicationPolicyId, ObjectReplicationPolicyInner properties) {
        return (ObjectReplicationPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId, properties).toBlocking().single()).body());
    }

    public ServiceFuture<ObjectReplicationPolicyInner> createOrUpdateAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, ObjectReplicationPolicyInner properties, ServiceCallback<ObjectReplicationPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId, properties), serviceCallback);
    }

    public Observable<ObjectReplicationPolicyInner> createOrUpdateAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, ObjectReplicationPolicyInner properties) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId, properties).map((Func1)new Func1<ServiceResponse<ObjectReplicationPolicyInner>, ObjectReplicationPolicyInner>(){

            public ObjectReplicationPolicyInner call(ServiceResponse<ObjectReplicationPolicyInner> response) {
                return (ObjectReplicationPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ObjectReplicationPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, ObjectReplicationPolicyInner properties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (objectReplicationPolicyId == null) {
            throw new IllegalArgumentException("Parameter objectReplicationPolicyId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Parameter properties is required and cannot be null.");
        }
        Validator.validate((Object)((Object)properties));
        return this.service.createOrUpdate(resourceGroupName, accountName, this.client.subscriptionId(), objectReplicationPolicyId, this.client.apiVersion(), properties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ObjectReplicationPolicyInner>>>(){

            public Observable<ServiceResponse<ObjectReplicationPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ObjectReplicationPoliciesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ObjectReplicationPolicyInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ObjectReplicationPolicyInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (objectReplicationPolicyId == null) {
            throw new IllegalArgumentException("Parameter objectReplicationPolicyId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, accountName, this.client.subscriptionId(), objectReplicationPolicyId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ObjectReplicationPoliciesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ObjectReplicationPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.ObjectReplicationPolicies list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.ObjectReplicationPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies/{objectReplicationPolicyId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="objectReplicationPolicyId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.ObjectReplicationPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies/{objectReplicationPolicyId}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="objectReplicationPolicyId") String var4, @Query(value="api-version") String var5, @Body ObjectReplicationPolicyInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.ObjectReplicationPolicies delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies/{objectReplicationPolicyId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="objectReplicationPolicyId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

