/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.storage.implementation.ListQueueInner;
import com.microsoft.azure.management.storage.implementation.PageImpl1;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.StorageQueueInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class QueuesInner {
    private QueuesService service;
    private StorageManagementClientImpl client;

    public QueuesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (QueuesService)retrofit.create(QueuesService.class);
        this.client = client;
    }

    public StorageQueueInner create(String resourceGroupName, String accountName, String queueName) {
        return (StorageQueueInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, queueName).toBlocking().single()).body());
    }

    public ServiceFuture<StorageQueueInner> createAsync(String resourceGroupName, String accountName, String queueName, ServiceCallback<StorageQueueInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, queueName), serviceCallback);
    }

    public Observable<StorageQueueInner> createAsync(String resourceGroupName, String accountName, String queueName) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, queueName).map((Func1)new Func1<ServiceResponse<StorageQueueInner>, StorageQueueInner>(){

            public StorageQueueInner call(ServiceResponse<StorageQueueInner> response) {
                return (StorageQueueInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageQueueInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String queueName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object metadata = null;
        StorageQueueInner queue = new StorageQueueInner();
        queue.withMetadata(null);
        return this.service.create(resourceGroupName, accountName, this.client.subscriptionId(), queueName, this.client.apiVersion(), this.client.acceptLanguage(), queue, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageQueueInner>>>(){

            public Observable<ServiceResponse<StorageQueueInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueuesInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public StorageQueueInner create(String resourceGroupName, String accountName, String queueName, Map<String, String> metadata) {
        return (StorageQueueInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, queueName, metadata).toBlocking().single()).body());
    }

    public ServiceFuture<StorageQueueInner> createAsync(String resourceGroupName, String accountName, String queueName, Map<String, String> metadata, ServiceCallback<StorageQueueInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, queueName, metadata), serviceCallback);
    }

    public Observable<StorageQueueInner> createAsync(String resourceGroupName, String accountName, String queueName, Map<String, String> metadata) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, queueName, metadata).map((Func1)new Func1<ServiceResponse<StorageQueueInner>, StorageQueueInner>(){

            public StorageQueueInner call(ServiceResponse<StorageQueueInner> response) {
                return (StorageQueueInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageQueueInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String queueName, Map<String, String> metadata) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(metadata);
        StorageQueueInner queue = new StorageQueueInner();
        queue.withMetadata(metadata);
        return this.service.create(resourceGroupName, accountName, this.client.subscriptionId(), queueName, this.client.apiVersion(), this.client.acceptLanguage(), queue, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageQueueInner>>>(){

            public Observable<ServiceResponse<StorageQueueInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueuesInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageQueueInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageQueueInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageQueueInner update(String resourceGroupName, String accountName, String queueName) {
        return (StorageQueueInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, queueName).toBlocking().single()).body());
    }

    public ServiceFuture<StorageQueueInner> updateAsync(String resourceGroupName, String accountName, String queueName, ServiceCallback<StorageQueueInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, queueName), serviceCallback);
    }

    public Observable<StorageQueueInner> updateAsync(String resourceGroupName, String accountName, String queueName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, queueName).map((Func1)new Func1<ServiceResponse<StorageQueueInner>, StorageQueueInner>(){

            public StorageQueueInner call(ServiceResponse<StorageQueueInner> response) {
                return (StorageQueueInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageQueueInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String queueName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object metadata = null;
        StorageQueueInner queue = new StorageQueueInner();
        queue.withMetadata(null);
        return this.service.update(resourceGroupName, accountName, this.client.subscriptionId(), queueName, this.client.apiVersion(), this.client.acceptLanguage(), queue, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageQueueInner>>>(){

            public Observable<ServiceResponse<StorageQueueInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueuesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public StorageQueueInner update(String resourceGroupName, String accountName, String queueName, Map<String, String> metadata) {
        return (StorageQueueInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, queueName, metadata).toBlocking().single()).body());
    }

    public ServiceFuture<StorageQueueInner> updateAsync(String resourceGroupName, String accountName, String queueName, Map<String, String> metadata, ServiceCallback<StorageQueueInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, queueName, metadata), serviceCallback);
    }

    public Observable<StorageQueueInner> updateAsync(String resourceGroupName, String accountName, String queueName, Map<String, String> metadata) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, queueName, metadata).map((Func1)new Func1<ServiceResponse<StorageQueueInner>, StorageQueueInner>(){

            public StorageQueueInner call(ServiceResponse<StorageQueueInner> response) {
                return (StorageQueueInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageQueueInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String queueName, Map<String, String> metadata) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(metadata);
        StorageQueueInner queue = new StorageQueueInner();
        queue.withMetadata(metadata);
        return this.service.update(resourceGroupName, accountName, this.client.subscriptionId(), queueName, this.client.apiVersion(), this.client.acceptLanguage(), queue, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageQueueInner>>>(){

            public Observable<ServiceResponse<StorageQueueInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueuesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageQueueInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageQueueInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageQueueInner get(String resourceGroupName, String accountName, String queueName) {
        return (StorageQueueInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, queueName).toBlocking().single()).body());
    }

    public ServiceFuture<StorageQueueInner> getAsync(String resourceGroupName, String accountName, String queueName, ServiceCallback<StorageQueueInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, queueName), serviceCallback);
    }

    public Observable<StorageQueueInner> getAsync(String resourceGroupName, String accountName, String queueName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, queueName).map((Func1)new Func1<ServiceResponse<StorageQueueInner>, StorageQueueInner>(){

            public StorageQueueInner call(ServiceResponse<StorageQueueInner> response) {
                return (StorageQueueInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageQueueInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String queueName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, this.client.subscriptionId(), queueName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageQueueInner>>>(){

            public Observable<ServiceResponse<StorageQueueInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueuesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageQueueInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageQueueInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName, String queueName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, queueName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String queueName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, queueName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String queueName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, queueName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String queueName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Parameter queueName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, accountName, this.client.subscriptionId(), queueName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueuesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ListQueueInner> list(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<ListQueueInner>((Page)response.body()){

            public Page<ListQueueInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)QueuesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ListQueueInner>> listAsync(String resourceGroupName, String accountName, ListOperationCallback<ListQueueInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(String nextPageLink) {
                return QueuesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ListQueueInner>> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<ListQueueInner>>, Page<ListQueueInner>>(){

            public Page<ListQueueInner> call(ServiceResponse<Page<ListQueueInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ListQueueInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<ListQueueInner>>, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(ServiceResponse<Page<ListQueueInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(QueuesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ListQueueInner>>> listSinglePageAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String maxpagesize = null;
        String filter = null;
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), maxpagesize, filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = QueuesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ListQueueInner> list(String resourceGroupName, String accountName, String maxpagesize, String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter).toBlocking().single();
        return new PagedList<ListQueueInner>((Page)response.body()){

            public Page<ListQueueInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)QueuesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ListQueueInner>> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListOperationCallback<ListQueueInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(String nextPageLink) {
                return QueuesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ListQueueInner>> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName, maxpagesize, filter).map((Func1)new Func1<ServiceResponse<Page<ListQueueInner>>, Page<ListQueueInner>>(){

            public Page<ListQueueInner> call(ServiceResponse<Page<ListQueueInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ListQueueInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName, String maxpagesize, String filter) {
        return this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter).concatMap((Func1)new Func1<ServiceResponse<Page<ListQueueInner>>, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(ServiceResponse<Page<ListQueueInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(QueuesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ListQueueInner>>> listSinglePageAsync(String resourceGroupName, String accountName, String maxpagesize, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), maxpagesize, filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = QueuesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ListQueueInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ListQueueInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ListQueueInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ListQueueInner>((Page)response.body()){

            public Page<ListQueueInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)QueuesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ListQueueInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ListQueueInner>> serviceFuture, ListOperationCallback<ListQueueInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(String nextPageLink) {
                return QueuesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ListQueueInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ListQueueInner>>, Page<ListQueueInner>>(){

            public Page<ListQueueInner> call(ServiceResponse<Page<ListQueueInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ListQueueInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ListQueueInner>>, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(ServiceResponse<Page<ListQueueInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(QueuesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ListQueueInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ListQueueInner>>>>(){

            public Observable<ServiceResponse<Page<ListQueueInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = QueuesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ListQueueInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ListQueueInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface QueuesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.Queues create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues/{queueName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="queueName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body StorageQueueInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.Queues update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues/{queueName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="queueName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body StorageQueueInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.Queues get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues/{queueName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="queueName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.Queues delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues/{queueName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="queueName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.Queues list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$maxpagesize") String var5, @Query(value="$filter") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.Queues listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

