/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.storage.CorsRules;
import com.microsoft.azure.management.storage.implementation.ListTableServicesInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.TableServicePropertiesInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class TableServicesInner {
    private TableServicesService service;
    private StorageManagementClientImpl client;

    public TableServicesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (TableServicesService)retrofit.create(TableServicesService.class);
        this.client = client;
    }

    public ListTableServicesInner list(String resourceGroupName, String accountName) {
        return (ListTableServicesInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<ListTableServicesInner> listAsync(String resourceGroupName, String accountName, ServiceCallback<ListTableServicesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<ListTableServicesInner> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<ListTableServicesInner>, ListTableServicesInner>(){

            public ListTableServicesInner call(ServiceResponse<ListTableServicesInner> response) {
                return (ListTableServicesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ListTableServicesInner>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ListTableServicesInner>>>(){

            public Observable<ServiceResponse<ListTableServicesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableServicesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ListTableServicesInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ListTableServicesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TableServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName) {
        return (TableServicePropertiesInner)((Object)((ServiceResponse)this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<TableServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, ServiceCallback<TableServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<TableServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<TableServicePropertiesInner>, TableServicePropertiesInner>(){

            public TableServicePropertiesInner call(ServiceResponse<TableServicePropertiesInner> response) {
                return (TableServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableServicePropertiesInner>> setServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String tableServiceName = "default";
        Object cors = null;
        TableServicePropertiesInner parameters = new TableServicePropertiesInner();
        parameters.withCors(null);
        return this.service.setServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableServicePropertiesInner>>>(){

            public Observable<ServiceResponse<TableServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableServicesInner.this.setServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public TableServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName, CorsRules cors) {
        return (TableServicePropertiesInner)((Object)((ServiceResponse)this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors).toBlocking().single()).body());
    }

    public ServiceFuture<TableServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, CorsRules cors, ServiceCallback<TableServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors), serviceCallback);
    }

    public Observable<TableServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, CorsRules cors) {
        return this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors).map((Func1)new Func1<ServiceResponse<TableServicePropertiesInner>, TableServicePropertiesInner>(){

            public TableServicePropertiesInner call(ServiceResponse<TableServicePropertiesInner> response) {
                return (TableServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableServicePropertiesInner>> setServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName, CorsRules cors) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)cors);
        String tableServiceName = "default";
        TableServicePropertiesInner parameters = new TableServicePropertiesInner();
        parameters.withCors(cors);
        return this.service.setServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableServicePropertiesInner>>>(){

            public Observable<ServiceResponse<TableServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableServicesInner.this.setServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TableServicePropertiesInner> setServicePropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TableServicePropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TableServicePropertiesInner getServiceProperties(String resourceGroupName, String accountName) {
        return (TableServicePropertiesInner)((Object)((ServiceResponse)this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<TableServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName, ServiceCallback<TableServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<TableServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<TableServicePropertiesInner>, TableServicePropertiesInner>(){

            public TableServicePropertiesInner call(ServiceResponse<TableServicePropertiesInner> response) {
                return (TableServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TableServicePropertiesInner>> getServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String tableServiceName = "default";
        return this.service.getServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TableServicePropertiesInner>>>(){

            public Observable<ServiceResponse<TableServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TableServicesInner.this.getServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TableServicePropertiesInner> getServicePropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TableServicePropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TableServicesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.TableServices list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.TableServices setServiceProperties"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices/{tableServiceName}")
        public Observable<Response<ResponseBody>> setServiceProperties(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="tableServiceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body TableServicePropertiesInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.TableServices getServiceProperties"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices/{tableServiceName}")
        public Observable<Response<ResponseBody>> getServiceProperties(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="tableServiceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

