/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.accessibility;

import jakarta.annotation.Nonnull;

public enum ColorFilter {
    BLUE_YELLOW("blue-yellow"),
    GREYSCALE("full"),
    NONE("none"),
    RED_GREEN("red-green");

    private final String value;

    private ColorFilter(String value) {
        this.value = value;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nonnull
    public static ColorFilter fromValue(String value) {
        for (ColorFilter filter : ColorFilter.values()) {
            if (!filter.getValue().equals(value)) continue;
            return filter;
        }
        throw new IllegalArgumentException("No %s is associated with value [\"%s\"]".formatted(ColorFilter.class.getSimpleName(), value));
    }
}

