/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.auth;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.oauth2.scopes.api.Scope;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OAuth2Scope implements Scope
{
    PUBLIC_REPOS,
    ACCOUNT_WRITE(Set.of(Permission.USER_ADMIN)),
    REPO_READ(Set.of(Permission.REPO_READ), Set.of(Permission.PROJECT_READ)),
    REPO_WRITE(Set.of(Permission.REPO_WRITE), Set.of(Permission.PROJECT_WRITE)),
    REPO_ADMIN(Set.of(Permission.REPO_ADMIN), Set.of(Permission.PROJECT_WRITE)),
    PROJECT_ADMIN(Set.of(Permission.PROJECT_ADMIN)),
    ADMIN_WRITE(Set.of(Permission.ADMIN)),
    SYSTEM_ADMIN(Set.of(Permission.SYS_ADMIN));

    public static final String PUBLIC_REPOS_NAME = "PUBLIC_REPOS";
    public static final String ACCOUNT_WRITE_NAME = "ACCOUNT_WRITE";
    public static final String REPO_READ_NAME = "REPO_READ";
    public static final String REPO_WRITE_NAME = "REPO_WRITE";
    public static final String REPO_ADMIN_NAME = "REPO_ADMIN";
    public static final String PROJECT_ADMIN_NAME = "PROJECT_ADMIN";
    public static final String ADMIN_WRITE_NAME = "ADMIN_WRITE";
    public static final String SYSTEM_ADMIN_NAME = "SYSTEM_ADMIN";
    private static final Logger log;
    private final Set<Permission> explicitPermissions;
    private final Set<Permission> permissionsImpliedForAnyResource;

    private OAuth2Scope() {
        this(Set.of(), Set.of());
    }

    private OAuth2Scope(Set<Permission> explicitPermissions) {
        this(explicitPermissions, Set.of());
    }

    private OAuth2Scope(Set<Permission> explicitPermissions, Set<Permission> permissionsImpliedForAnyResource) {
        this.explicitPermissions = Set.copyOf(this.calculatePermissions(explicitPermissions, Permission.LICENSED_USER));
        this.permissionsImpliedForAnyResource = Set.copyOf(this.calculatePermissions(permissionsImpliedForAnyResource, new Permission[0]));
    }

    public static Set<OAuth2Scope> from(Set<Scope> scopes) {
        return scopes.stream().map(scope -> {
            try {
                return OAuth2Scope.valueOf(scope.getName());
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid scope name: {}", (Object)scope.getName());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nonnull
    private Set<Permission> calculatePermissions(Set<Permission> directPermissions, Permission ... extraPermissions) {
        HashSet<Permission> allPermissions = new HashSet<Permission>(directPermissions);
        directPermissions.forEach(directPermission -> allPermissions.addAll(this.recursivelyGetPermissions((Permission)directPermission)));
        if (extraPermissions != null && extraPermissions.length > 0) {
            allPermissions.addAll(Set.of(extraPermissions));
        }
        return allPermissions;
    }

    public Set<Permission> getAllPermissions(boolean includeImplicitPermissions) {
        Stream allPermissions = this.explicitPermissions.stream();
        if (includeImplicitPermissions) {
            allPermissions = Stream.concat(allPermissions, this.permissionsImpliedForAnyResource.stream());
        }
        return allPermissions.collect(Collectors.toSet());
    }

    public Set<Permission> getGlobalPermissions() {
        return this.getAllPermissions(true).stream().filter(Permission::isGlobal).collect(Collectors.toSet());
    }

    @Nonnull
    public String getName() {
        return this.name();
    }

    @Nonnull
    public Set<Scope> getScopeAndInheritedScopes() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getSupportedGrantTypes() {
        throw new UnsupportedOperationException();
    }

    private Set<Permission> recursivelyGetPermissions(Permission permission) {
        Set inheritedPermissions = permission.getInheritedPermissions();
        HashSet<Permission> allPermissions = new HashSet<Permission>(inheritedPermissions);
        if (!inheritedPermissions.isEmpty()) {
            inheritedPermissions.forEach(inheritedPermission -> allPermissions.addAll(this.recursivelyGetPermissions((Permission)inheritedPermission)));
        }
        return allPermissions;
    }

    static {
        log = LoggerFactory.getLogger(OAuth2Scope.class);
    }
}

