/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.build.status;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BuildStatusParentSearchRequest {
    private final String filter;
    private final Repository repository;
    private final Date since;

    private BuildStatusParentSearchRequest(Builder builder) {
        this.filter = builder.filter;
        this.repository = builder.repository;
        this.since = builder.since;
    }

    @Nonnull
    public String getFilter() {
        return this.filter;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Optional<Date> getSince() {
        return Optional.ofNullable(this.since);
    }

    public static class Builder {
        private final String filter;
        private final Repository repository;
        private Date since;

        public Builder(@Nonnull Repository repository, @Nonnull String filter) {
            this.filter = Objects.requireNonNull(StringUtils.stripToNull((String)filter), "filter");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        public BuildStatusParentSearchRequest build() {
            return new BuildStatusParentSearchRequest(this);
        }

        public Builder since(@Nullable Long epochSeconds) {
            if (epochSeconds != null) {
                this.since = Date.from(Instant.ofEpochSecond(epochSeconds));
            }
            return this;
        }
    }
}

