/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.build.status;

import com.atlassian.bitbucket.dmz.build.status.AbstractBuildStatusSummaryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public final class BulkRefBuildStatusSummaryRequest
extends AbstractBuildStatusSummaryRequest {
    private final Collection<String> refs;

    private BulkRefBuildStatusSummaryRequest(Builder builder) {
        super(builder);
        this.refs = builder.refs.build();
    }

    @Nonnull
    public Collection<String> getRefs() {
        return this.refs;
    }

    public static class Builder
    extends AbstractBuildStatusSummaryRequest.AbstractBuilder<Builder> {
        private final ImmutableList.Builder<String> refs = new ImmutableList.Builder();

        public Builder(@Nonnull Repository repository, String ... refs) {
            super(Objects.requireNonNull(repository, "repository"));
            this.refs.addAll(Arrays.asList(refs));
        }

        public Builder(@Nonnull Repository repository, Set<String> refs) {
            super(Objects.requireNonNull(repository, "repository"));
            this.refs.addAll((Iterable)Objects.requireNonNull(refs, "refs"));
        }

        public Builder(@Nonnull BulkRefBuildStatusSummaryRequest request) {
            super(Objects.requireNonNull(request, "request"));
            this.refs.addAll(request.getRefs());
        }

        @Override
        @Nonnull
        public BulkRefBuildStatusSummaryRequest build() {
            return new BulkRefBuildStatusSummaryRequest(this);
        }

        public Builder refs(@Nonnull Collection<String> refs) {
            Objects.requireNonNull(refs, "refs");
            this.refs.addAll(refs);
            return this.self();
        }

        @Override
        @Nonnull
        public Builder self() {
            return this;
        }
    }
}

