/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.build.status;

import com.atlassian.bitbucket.build.status.TestResults;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;

public final class SimpleTestResults
implements TestResults {
    private final Integer failed;
    private final Integer skipped;
    private final Integer successful;

    private SimpleTestResults(Builder builder) {
        this.failed = builder.failed;
        this.skipped = builder.skipped;
        this.successful = builder.successful;
    }

    @Nonnull
    public Optional<Integer> getFailed() {
        return Optional.ofNullable(this.failed);
    }

    @Nonnull
    public Optional<Integer> getSkipped() {
        return Optional.ofNullable(this.skipped);
    }

    @Nonnull
    public Optional<Integer> getSuccessful() {
        return Optional.ofNullable(this.successful);
    }

    public static final class Builder {
        Integer failed;
        Integer skipped;
        Integer successful;

        @Nonnull
        public TestResults build() {
            return new SimpleTestResults(this);
        }

        @Nonnull
        public Builder failed(@Nullable Integer failed) {
            this.failed = failed;
            return this;
        }

        @Nonnull
        public Builder skipped(@Nullable Integer skipped) {
            this.skipped = skipped;
            return this;
        }

        @Nonnull
        public Builder successful(@Nullable Integer successful) {
            this.successful = successful;
            return this;
        }
    }
}

