/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.build.status.legacy;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.UrlHrefUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public final class SimpleLegacyBuildStatus
implements LegacyBuildStatus {
    private final String commitId;
    private final BuildState state;
    private final String key;
    private final String name;
    private final String url;
    private final String description;
    private final Date dateAdded;

    private SimpleLegacyBuildStatus(Builder builder) {
        this.commitId = builder.commitId;
        this.dateAdded = builder.dateAdded;
        this.description = builder.description;
        this.key = builder.key;
        this.name = builder.name;
        this.state = builder.state;
        this.url = UrlHrefUtils.getSanitizedUrl((String)builder.url);
    }

    @Override
    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Override
    @Nonnull
    public Date getCreatedDate() {
        return this.dateAdded;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public BuildState getState() {
        return this.state;
    }

    @Override
    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nonnull
    public Date getUpdatedDate() {
        return this.dateAdded;
    }

    public static final class Builder
    extends BuilderSupport {
        private Date dateAdded;
        private String description;
        private String commitId;
        private String key;
        private String name;
        private BuildState state;
        private String url;

        public Builder(RepositoryBuildStatus buildStatus) {
            this.dateAdded = buildStatus.getUpdatedDate();
            this.description = buildStatus.getDescription().orElse(null);
            this.commitId = buildStatus.getCommitId();
            this.key = buildStatus.getKey();
            this.name = buildStatus.getName().orElse(null);
            this.state = buildStatus.getState();
            this.url = buildStatus.getUrl();
        }

        public Builder(LegacyBuildStatus buildStatus) {
            this.dateAdded = buildStatus.getUpdatedDate();
            this.description = buildStatus.getDescription();
            this.commitId = buildStatus.getCommitId();
            this.key = buildStatus.getKey();
            this.name = buildStatus.getName();
            this.state = buildStatus.getState();
            this.url = buildStatus.getUrl();
        }

        public Builder() {
        }

        @Nonnull
        public Builder dateAdded(@Nullable Date value) {
            this.dateAdded = value;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public Builder commitId(@Nonnull String value) {
            this.commitId = Builder.requireNonBlank((String)value, (String)"commitId");
            return this;
        }

        @Nonnull
        public Builder key(@Nonnull String value) {
            this.key = Builder.requireNonBlank((String)value, (String)"key");
            return this;
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull BuildState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String value) {
            this.url = Builder.requireNonBlank((String)value, (String)"url");
            return this;
        }

        public LegacyBuildStatus build() {
            return new SimpleLegacyBuildStatus(this);
        }
    }
}

