/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.comment;

import com.atlassian.bitbucket.comment.AddLineCommentRequest;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.comment.LineNumberRange;
import com.atlassian.bitbucket.content.DiffSegmentType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class AddMultilineCommentRequest
extends AddLineCommentRequest {
    private final LineNumberRange destinationSpan;
    private final LineNumberRange sourceSpan;
    private final int startLine;
    private final DiffSegmentType startLineType;

    private AddMultilineCommentRequest(Builder builder) {
        super((AddLineCommentRequest.AbstractLineCommentRequestBuilder)builder);
        this.destinationSpan = builder.destinationSpan;
        this.sourceSpan = builder.sourceSpan;
        this.startLine = builder.startLine;
        this.startLineType = builder.startLineType;
    }

    @Nullable
    public LineNumberRange getDestinationSpan() {
        return this.destinationSpan;
    }

    @Nullable
    public LineNumberRange getSourceSpan() {
        return this.sourceSpan;
    }

    public int getStartLine() {
        return this.startLine;
    }

    @Nonnull
    public DiffSegmentType getStartLineType() {
        return this.startLineType;
    }

    public static class Builder
    extends AddLineCommentRequest.AbstractLineCommentRequestBuilder<Builder, AddMultilineCommentRequest> {
        private final int startLine;
        private final DiffSegmentType startLineType;
        private LineNumberRange destinationSpan;
        private LineNumberRange sourceSpan;

        public Builder(@Nonnull Commentable commentable, @Nonnull String text, @Nonnull CommentThreadDiffAnchorType diffType, @Nonnull String path, int startLine, @Nonnull DiffSegmentType startLineType) {
            super(commentable, text, diffType, path);
            this.startLine = startLine;
            this.startLineType = startLineType;
        }

        @Nonnull
        public AddMultilineCommentRequest build() {
            return new AddMultilineCommentRequest(this);
        }

        @Nonnull
        public Builder destinationSpan(@Nonnull LineNumberRange dstSpan) {
            this.destinationSpan = Objects.requireNonNull(dstSpan, "dstSpan");
            return this;
        }

        @Nonnull
        public Builder sourceSpan(@Nonnull LineNumberRange srcSpan) {
            this.sourceSpan = Objects.requireNonNull(srcSpan, "srcSpan");
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

