/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.deployments;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum DeploymentEnvironmentType {
    DEVELOPMENT(100),
    TESTING(200),
    STAGING(300),
    PRODUCTION(400);

    private final int priority;

    private DeploymentEnvironmentType(int priority) {
        this.priority = priority;
    }

    @Nonnull
    public static Optional<DeploymentEnvironmentType> fromString(@Nullable String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return Optional.empty();
        }
        return Arrays.stream(DeploymentEnvironmentType.values()).filter(v -> v.name().equalsIgnoreCase(type)).findAny();
    }

    public int getPriority() {
        return this.priority;
    }
}

