/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.deployments;

import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentSetRequest;
import com.atlassian.bitbucket.dmz.deployments.DeploymentSourceTool;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class DeploymentSetRequest {
    private final String commitId;
    private final long deploymentSequenceNumber;
    private final String description;
    private final String displayName;
    private final DeploymentEnvironmentSetRequest environmentRequest;
    private final String key;
    private final Date lastUpdated;
    private final Repository repository;
    private final DeploymentSourceTool sourceTool;
    private final DeploymentState state;
    private final URI url;

    private DeploymentSetRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.key = builder.key;
        this.deploymentSequenceNumber = builder.deploymentSequenceNumber;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.environmentRequest = builder.environmentRequest;
        this.lastUpdated = (Date)MoreObjects.firstNonNull((Object)builder.lastUpdated, (Object)new Date());
        this.repository = builder.repository;
        this.sourceTool = builder.sourceTool;
        this.state = builder.state;
        this.url = builder.url;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public long getDeploymentSequenceNumber() {
        return this.deploymentSequenceNumber;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public DeploymentEnvironmentSetRequest getEnvironmentRequest() {
        return this.environmentRequest;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public DeploymentSourceTool getSourceTool() {
        return this.sourceTool;
    }

    @Nonnull
    public DeploymentState getState() {
        return this.state;
    }

    @Nonnull
    public URI getUrl() {
        return this.url;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final long deploymentSequenceNumber;
        private final String description;
        private final String displayName;
        private final DeploymentEnvironmentSetRequest environmentRequest;
        private final String key;
        private final Repository repository;
        private final DeploymentState state;
        private final URI url;
        private Date lastUpdated;
        private DeploymentSourceTool sourceTool = DeploymentSourceTool.UNKNOWN;

        public Builder(@Nonnull String commitId, long deploymentSequenceNumber, @Nonnull String description, @Nonnull String displayName, @Nonnull DeploymentEnvironmentSetRequest environmentRequest, @Nonnull String key, @Nonnull Repository repository, @Nonnull DeploymentState state, @Nonnull URI url) {
            this.commitId = Builder.requireNonBlank((String)StringUtils.stripToNull((String)commitId), (String)"commitId");
            this.key = Builder.requireNonBlank((String)StringUtils.stripToNull((String)key), (String)"key");
            this.deploymentSequenceNumber = deploymentSequenceNumber;
            this.displayName = Builder.requireNonBlank((String)StringUtils.stripToNull((String)displayName), (String)"displayName");
            this.description = Builder.requireNonBlank((String)StringUtils.stripToNull((String)description), (String)"description");
            this.environmentRequest = Objects.requireNonNull(environmentRequest, "environment");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.state = Objects.requireNonNull(state, "state");
            this.url = Objects.requireNonNull(url, "uel");
        }

        @Nonnull
        public DeploymentSetRequest build() {
            return new DeploymentSetRequest(this);
        }

        @Nonnull
        public Builder lastUpdated(@Nullable Date value) {
            this.lastUpdated = value;
            return this;
        }

        @Nonnull
        public Builder sourceTool(@Nonnull DeploymentSourceTool value) {
            this.sourceTool = Objects.requireNonNull(value, "deploymentSourceTool");
            return this;
        }
    }
}

