/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mergequeue;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class QueuedPullRequestSearchRequest {
    private static final int MAX_REFS_TO_SEARCH = 50;
    private final Set<String> toRefIds;
    private final int toRepositoryId;

    private QueuedPullRequestSearchRequest(Builder builder) {
        this.toRefIds = builder.toRefIds.build();
        this.toRepositoryId = builder.toRepositoryId;
        Preconditions.checkArgument((this.toRefIds.size() <= 50 ? 1 : 0) != 0, (String)"ref count %s exceeds max allowed value %s", (int)this.toRefIds.size(), (int)50);
    }

    @Nonnull
    public Set<String> getToRefIds() {
        return this.toRefIds;
    }

    public int getToRepositoryId() {
        return this.toRepositoryId;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> toRefIds;
        private final int toRepositoryId;

        public Builder(int toRepositoryId) {
            this.toRepositoryId = toRepositoryId;
            this.toRefIds = ImmutableSet.builder();
        }

        @Nonnull
        public QueuedPullRequestSearchRequest build() {
            return new QueuedPullRequestSearchRequest(this);
        }

        @Nonnull
        public Builder toRefId(@Nullable String value) {
            Builder.addIf(Objects::nonNull, this.toRefIds, (Object)value);
            return this;
        }

        @Nonnull
        public Builder toRefIds(@Nonnull Set<String> values) {
            Objects.requireNonNull(values, "values");
            this.toRefIds.addAll(values);
            return this;
        }
    }
}

