/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mergequeue;

import com.atlassian.bitbucket.scope.Scope;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class SetMergeQueueSettingsRequest {
    private final boolean enabled;
    private final Duration mergeTimeout;
    private final Scope scope;

    private SetMergeQueueSettingsRequest(Builder builder) {
        this.enabled = builder.enabled;
        this.scope = builder.scope;
        this.mergeTimeout = builder.mergeTimeout;
    }

    @Nonnull
    public Optional<Duration> getMergeTimeout() {
        return Duration.ZERO.equals(this.mergeTimeout) ? Optional.empty() : Optional.ofNullable(this.mergeTimeout);
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private final Scope scope;
        private boolean enabled;
        private Duration mergeTimeout;

        public Builder(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        @Nonnull
        public SetMergeQueueSettingsRequest build() {
            return new SetMergeQueueSettingsRequest(this);
        }

        @Nonnull
        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public Builder mergeTimeout(@Nullable Duration value) {
            Duration mergeTimeout = value != null ? value : Duration.ZERO;
            Preconditions.checkArgument((!mergeTimeout.isNegative() ? 1 : 0) != 0, (Object)"Merge timeout cannot be negative");
            this.mergeTimeout = mergeTimeout;
            return this;
        }
    }
}

