/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import com.atlassian.bitbucket.dmz.mesh.ConnectivityNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MeshConnectivitySummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final ConnectivityNode node;
    private final boolean reachable;
    private final long roundTripTime;

    private MeshConnectivitySummary(Builder builder) {
        Objects.requireNonNull(builder, "builder");
        this.errorMessage = builder.errorMessage;
        this.node = Objects.requireNonNull(builder.node, "node");
        this.reachable = builder.reachable;
        this.roundTripTime = builder.roundTripTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeshConnectivitySummary that = (MeshConnectivitySummary)o;
        return StringUtils.equals((CharSequence)this.errorMessage, (CharSequence)that.errorMessage) && Objects.equals(this.node, that.node) && this.reachable == that.reachable && this.roundTripTime == that.roundTripTime;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nonnull
    public ConnectivityNode getNode() {
        return this.node;
    }

    public long getRoundTripTime() {
        return this.roundTripTime;
    }

    public int hashCode() {
        return Objects.hash(this.getErrorMessage(), this.getNode(), this.getRoundTripTime(), this.isReachable());
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public static class Builder {
        private final ConnectivityNode node;
        private String errorMessage;
        private boolean reachable;
        private long roundTripTime;

        public Builder(@Nonnull ConnectivityNode node) {
            this.node = Objects.requireNonNull(node, "node");
            this.roundTripTime = -1L;
        }

        @Nonnull
        public MeshConnectivitySummary build() {
            return new MeshConnectivitySummary(this);
        }

        @Nonnull
        public Builder errorMessage(String value) {
            this.errorMessage = value;
            return this;
        }

        @Nonnull
        public Builder reachable(boolean value) {
            this.reachable = value;
            return this;
        }

        @Nonnull
        public Builder roundTripTime(long value) {
            this.roundTripTime = value;
            return this;
        }
    }
}

