/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;

public enum MeshPartitionMigrationJobState {
    INITIALIZING(1, false, false, true),
    SYNCHRONIZING(2, true, false, true),
    DRAINING(3, true, false, true),
    DELETING(4, false, false, false),
    FINISHED(5, false, true, false),
    CANCELLING(6, false, false, false),
    CANCELLED(7, false, true, false),
    FAILED(8, false, true, false);

    public static EnumSet<MeshPartitionMigrationJobState> NON_TERMINAL_STATES;
    private final boolean cancellable;
    private final int id;
    private final boolean sendTopology;
    private final boolean terminal;

    private MeshPartitionMigrationJobState(int id, boolean sendTopology, boolean terminal, boolean cancellable) {
        this.terminal = terminal;
        this.id = id;
        this.sendTopology = sendTopology;
        this.cancellable = cancellable;
    }

    @Nonnull
    public static MeshPartitionMigrationJobState fromId(int id) {
        for (MeshPartitionMigrationJobState value : MeshPartitionMigrationJobState.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No MeshPartitionMigrationJobState is associated with ID [" + id + "]");
    }

    public int getId() {
        return this.id;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public boolean shouldSendTopology() {
        return this.sendTopology;
    }

    static {
        NON_TERMINAL_STATES = Arrays.stream(MeshPartitionMigrationJobState.values()).filter(state -> !state.isTerminal()).collect(Collectors.toCollection(() -> EnumSet.noneOf(MeshPartitionMigrationJobState.class)));
    }
}

