/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class MeshPartitionMigrationRequest {
    private final int partitionId;
    private final MeshNode sourceNode;
    private final MeshNode targetNode;

    public MeshPartitionMigrationRequest(Builder builder) {
        this.partitionId = builder.partitionId;
        this.sourceNode = builder.sourceNode;
        this.targetNode = builder.targetNode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("sourceNode", (Object)this.sourceNode).add("targetNode", (Object)this.targetNode).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeshPartitionMigrationRequest that = (MeshPartitionMigrationRequest)o;
        return this.partitionId == that.partitionId && this.sourceNode.equals((Object)that.sourceNode) && this.targetNode.equals((Object)that.targetNode);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public MeshNode getSourceNode() {
        return this.sourceNode;
    }

    public MeshNode getTargetNode() {
        return this.targetNode;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.sourceNode, this.targetNode);
    }

    public static class Builder {
        int partitionId;
        MeshNode sourceNode;
        MeshNode targetNode;

        public Builder(int partitionId, MeshNode sourceNode, MeshNode targetNode) {
            this.partitionId = partitionId;
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
        }

        @Nonnull
        public MeshPartitionMigrationRequest build() {
            return new MeshPartitionMigrationRequest(this);
        }

        @Nonnull
        public Builder partitionId(int value) {
            this.partitionId = value;
            return this;
        }

        @Nonnull
        public Builder sourceNode(@Nonnull MeshNode value) {
            Objects.requireNonNull(value, "value");
            this.sourceNode = value;
            return this;
        }

        @Nonnull
        public Builder targetNode(@Nonnull MeshNode value) {
            Objects.requireNonNull(value, "value");
            this.targetNode = value;
            return this;
        }
    }
}

