/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public interface MeshPartitionReplica {
    public long getId();

    @Nonnull
    public MeshNode getNode();

    public int getPartition();

    @Nonnull
    public State getState();

    public boolean isAvailable();

    public static enum State {
        AVAILABLE(1, "Available"),
        DISABLED(2, "Disabled"),
        DRAINING(3, "Draining");

        private final int id;
        private final String statusMessage;

        private State(int id, String statusMessage) {
            this.id = id;
            this.statusMessage = Objects.requireNonNull(statusMessage, "statusMessage");
        }

        public static State fromId(int id) {
            for (State value : State.values()) {
                if (value.getId() != id) continue;
                return value;
            }
            throw new IllegalArgumentException("No Replica.State is associated with ID [" + id + "]");
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String getStatusMessage() {
            return this.statusMessage;
        }
    }
}

