/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class RepositoryReplicaDetails {
    private final String contentHash;
    private final String metadataHash;
    private final long observedVersion;
    private final ReplicaState replicaState;
    private final long version;

    private RepositoryReplicaDetails(Builder builder) {
        this.contentHash = builder.contentHash;
        this.metadataHash = builder.metadataHash;
        this.observedVersion = builder.observedVersion;
        this.replicaState = builder.replicaState;
        this.version = builder.version;
    }

    @Nullable
    public String getContentHash() {
        return this.contentHash;
    }

    @Nullable
    public String getMetadataHash() {
        return this.metadataHash;
    }

    public long getObservedVersion() {
        return this.observedVersion;
    }

    @Nonnull
    public ReplicaState getReplicaState() {
        return this.replicaState;
    }

    public long getVersion() {
        return this.version;
    }

    public static class Builder {
        private final ReplicaState replicaState;
        private String contentHash;
        private String metadataHash;
        private long observedVersion;
        private long version;

        public Builder(@Nonnull ReplicaState replicaState) {
            this.replicaState = Objects.requireNonNull(replicaState, "replicaState");
        }

        @Nonnull
        public RepositoryReplicaDetails build() {
            return new RepositoryReplicaDetails(this);
        }

        @Nonnull
        public Builder contentHash(@Nullable String value) {
            this.contentHash = value;
            return this;
        }

        @Nonnull
        public Builder metadataHash(@Nullable String value) {
            this.metadataHash = value;
            return this;
        }

        @Nonnull
        public Builder observedVersion(long value) {
            this.observedVersion = value;
            return this;
        }

        @Nonnull
        public Builder version(long value) {
            this.version = value;
            return this;
        }
    }
}

