/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class UpdatePartitionReplicaStateRequest {
    private final MeshNode node;
    private final int partition;
    private final StateUpdate state;

    private UpdatePartitionReplicaStateRequest(Builder builder) {
        this.node = builder.node;
        this.partition = builder.partition;
        this.state = builder.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdatePartitionReplicaStateRequest that = (UpdatePartitionReplicaStateRequest)o;
        return this.partition == that.partition && Objects.equals(this.node, that.node) && Objects.equals((Object)this.state, (Object)that.state);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node", (Object)this.node).add("partition", this.partition).add("state", (Object)this.state).toString();
    }

    @Nonnull
    public MeshNode getNode() {
        return this.node;
    }

    public int getPartition() {
        return this.partition;
    }

    @Nonnull
    public StateUpdate getState() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.node, this.partition, this.state});
    }

    public static class Builder {
        public MeshNode node;
        public int partition;
        public StateUpdate state;

        public Builder(UpdatePartitionReplicaStateRequest other) {
            this.node = other.node;
            this.partition = other.partition;
            this.state = other.state;
        }

        public Builder(@Nonnull MeshNode node, int partition, @Nonnull StateUpdate state) {
            this.node = Objects.requireNonNull(node, "node");
            this.partition = partition;
            this.state = Objects.requireNonNull(state, "state");
        }

        public UpdatePartitionReplicaStateRequest build() {
            return new UpdatePartitionReplicaStateRequest(this);
        }

        public Builder meshNode(@Nonnull MeshNode value) {
            this.node = Objects.requireNonNull(value, "meshNode");
            return this;
        }

        public Builder partition(int value) {
            this.partition = value;
            return this;
        }

        public Builder state(@Nonnull StateUpdate value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }
    }

    public static enum StateUpdate {
        AVAILABLE(MeshPartitionReplica.State.AVAILABLE),
        DISABLED(MeshPartitionReplica.State.DISABLED);

        private final MeshPartitionReplica.State replicaState;

        private StateUpdate(MeshPartitionReplica.State replicaState) {
            this.replicaState = replicaState;
        }

        public MeshPartitionReplica.State getState() {
            return this.replicaState;
        }
    }
}

