/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.migration;

import com.atlassian.bitbucket.dmz.migration.MeshMigrationQueueState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.util.MoreStreams;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MigrationRepositorySearchRequest {
    private final Long jobId;
    private final Set<String> projectKeys;
    private final Boolean remote;
    private final String repositoryName;
    private final Set<MeshMigrationQueueState> states;

    private MigrationRepositorySearchRequest(Builder builder) {
        this.jobId = builder.jobId;
        this.projectKeys = builder.projectKeys.build();
        this.remote = builder.remote;
        this.repositoryName = builder.repositoryName;
        this.states = builder.states.build();
    }

    @Nonnull
    public Optional<Long> getJobId() {
        return Optional.ofNullable(this.jobId);
    }

    @Nonnull
    public Set<String> getProjectKeys() {
        return this.projectKeys;
    }

    @Nonnull
    public Optional<Boolean> getRemote() {
        return Optional.ofNullable(this.remote);
    }

    @Nonnull
    public Optional<String> getRepositoryName() {
        return Optional.ofNullable(this.repositoryName);
    }

    @Nonnull
    public Set<MeshMigrationQueueState> getStates() {
        return this.states;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> projectKeys = new ImmutableSet.Builder();
        private final ImmutableSet.Builder<MeshMigrationQueueState> states = new ImmutableSet.Builder();
        private Long jobId;
        private Boolean remote;
        private String repositoryName;

        public Builder() {
        }

        public Builder(@Nonnull MigrationRepositorySearchRequest searchRequest) {
            Objects.requireNonNull(searchRequest, "searchRequest");
            this.remote = searchRequest.getRemote().orElse(null);
            this.jobId = searchRequest.getJobId().orElse(null);
            this.projectKeys.addAll(searchRequest.getProjectKeys());
            this.repositoryName = searchRequest.getRepositoryName().orElse(null);
            this.states.addAll(searchRequest.getStates());
        }

        @Nonnull
        public MigrationRepositorySearchRequest build() {
            return new MigrationRepositorySearchRequest(this);
        }

        @Nonnull
        public Builder jobId(@Nullable Long value) {
            this.jobId = value;
            return this;
        }

        @Nonnull
        public Builder projectKey(@Nullable String value) {
            Builder.addIf((Predicate)NOT_BLANK, this.projectKeys, (Object)this.keyifyProjectKey(value));
            return this;
        }

        @Nonnull
        public Builder projectKeys(@Nullable Iterable<String> values) {
            if (values != null) {
                Builder.addIf((Predicate)NOT_BLANK, this.projectKeys, (Iterable)MoreStreams.streamIterable(values).map(this::keyifyProjectKey).collect(Collectors.toSet()));
            }
            return this;
        }

        @Nonnull
        public Builder remote(@Nullable Boolean value) {
            this.remote = value;
            return this;
        }

        @Nonnull
        public Builder repositoryName(@Nullable String value) {
            this.repositoryName = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nullable MeshMigrationQueueState value) {
            Builder.addIf(Objects::nonNull, this.states, (Object)((Object)value));
            return this;
        }

        @Nonnull
        public Builder states(@Nullable Iterable<MeshMigrationQueueState> values) {
            Builder.addIf(Objects::nonNull, this.states, values);
            return this;
        }

        private String keyifyProjectKey(String key) {
            return StringUtils.upperCase((String)StringUtils.trimToNull((String)key), (Locale)Locale.ROOT);
        }
    }
}

