/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mirror;

import com.atlassian.bitbucket.dmz.mirror.FarmQueueRequest;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

public class ReadOnlyFarmQueueRequest<T extends Serializable> {
    private final int attempt;
    private final T value;

    public ReadOnlyFarmQueueRequest(@Nonnull FarmQueueRequest<T> request) {
        Objects.requireNonNull(request, "request");
        this.attempt = request.getAttempt();
        this.value = request.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadOnlyFarmQueueRequest that = (ReadOnlyFarmQueueRequest)o;
        return this.attempt == that.attempt && this.value.equals(that.value);
    }

    public int getAttempt() {
        return this.attempt;
    }

    @Nonnull
    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.attempt);
    }
}

