/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.pull;

import com.atlassian.bitbucket.dmz.pull.PreparedPullRequestMerge;
import com.atlassian.bitbucket.repository.Branch;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SimplePreparedPullRequestMerge
implements PreparedPullRequestMerge {
    private final Branch branch;
    private final String expectedTargetCommit;
    private final String mergeMessage;
    private final String mergeStrategyId;

    private SimplePreparedPullRequestMerge(Builder builder) {
        this.branch = builder.branch;
        this.expectedTargetCommit = builder.expectedTargetCommit;
        this.mergeMessage = builder.mergeMessage;
        this.mergeStrategyId = builder.mergeStrategyId;
    }

    @Override
    @Nonnull
    public Branch getBranch() {
        return this.branch;
    }

    @Override
    @Nonnull
    public String getExpectedTargetCommit() {
        return this.expectedTargetCommit;
    }

    @Override
    @Nullable
    public String getMergeMessage() {
        return this.mergeMessage;
    }

    @Override
    @Nullable
    public String getMergeStrategyId() {
        return this.mergeStrategyId;
    }

    public static class Builder {
        private final Branch branch;
        private final String expectedTargetCommit;
        private String mergeMessage;
        private String mergeStrategyId;

        public Builder(@Nonnull Branch branch, @Nonnull String expectedTargetCommit) {
            this.branch = Objects.requireNonNull(branch, "branch");
            this.expectedTargetCommit = Objects.requireNonNull(expectedTargetCommit, "expectedTargetCommit");
        }

        @Nonnull
        public SimplePreparedPullRequestMerge build() {
            return new SimplePreparedPullRequestMerge(this);
        }

        @Nonnull
        public Builder mergeMessage(@Nullable String value) {
            this.mergeMessage = value;
            return this;
        }

        @Nonnull
        public Builder mergeStrategyId(@Nullable String value) {
            this.mergeStrategyId = value;
            return this;
        }
    }
}

