/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.ratelimit;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.ratelimit.settings.default.modified")
@TransactionAware
public class DefaultRateLimitSettingsModifiedEvent
extends ApplicationEvent {
    private final TokenBucketSettings newSettings;
    private final TokenBucketSettings oldSettings;

    public DefaultRateLimitSettingsModifiedEvent(@Nonnull TokenBucketSettings newSettings, @Nonnull TokenBucketSettings oldSettings, @Nonnull Object source) {
        super(source);
        this.newSettings = Objects.requireNonNull(newSettings, "newSettings");
        this.oldSettings = Objects.requireNonNull(oldSettings, "oldSettings");
    }

    public int getNewCapacity() {
        return this.newSettings.getCapacity();
    }

    public int getNewFillRate() {
        return this.newSettings.getFillRate();
    }

    public int getOldCapacity() {
        return this.oldSettings.getCapacity();
    }

    public int getOldFillRate() {
        return this.oldSettings.getFillRate();
    }
}

