/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.repository;

import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RemoteRepositoryId {
    private static final Pattern PATTERN_REMOTE_REPO_ID = Pattern.compile("p/(?<partition>[0-9a-f]{4,})/h/(?<hierarchy>[0-9a-z]{20,})/r/(?<repository>[\\d]+)(\\?.*q=(?<quarantine>[0-9a-z]+))?");
    private final String hierarchyId;
    private final int localId;
    private final int partition;

    public RemoteRepositoryId(@Nonnull DmzRepository repository) {
        this(Objects.requireNonNull(repository).getPartition(), repository.getHierarchyId(), repository.getId());
    }

    public RemoteRepositoryId(int partition, @Nonnull String hierarchyId, int localId) {
        this.hierarchyId = Objects.requireNonNull(hierarchyId, "hierarchyId");
        this.localId = localId;
        this.partition = partition;
    }

    @Nonnull
    public static String format(@Nonnull DmzRepository repository) {
        Objects.requireNonNull(repository, "repository");
        Preconditions.checkArgument((boolean)repository.isRemote(), (Object)"Remote IDs are not available for local repositories");
        return RemoteRepositoryId.format(repository.getPartition(), repository.getHierarchyId(), repository.getId());
    }

    @Nonnull
    public static String format(int partition, @Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        Preconditions.checkArgument((boolean)repository.isLocal(), (String)"%s is not a local repository", (Object)repository);
        return RemoteRepositoryId.format(partition, repository.getHierarchyId(), repository.getId());
    }

    @Nonnull
    public static String format(int partition, @Nonnull String hierarchyId, int localId) {
        return "p/" + RemoteRepositoryId.getPartitionHex(partition) + "/h/" + hierarchyId + "/r/" + localId;
    }

    public static int getPartition(@Nonnull String repositoryId) {
        Objects.requireNonNull(repositoryId, "repositoryId");
        Matcher matcher = PATTERN_REMOTE_REPO_ID.matcher(repositoryId);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group("partition"), 16);
        }
        return -1;
    }

    @Nonnull
    public static String getPartitionHex(int partition) {
        return StringUtils.leftPad((String)Integer.toHexString(partition), (int)4, (char)'0');
    }

    @Nullable
    public static RemoteRepositoryId parse(@Nonnull String repositoryId) {
        Objects.requireNonNull(repositoryId, "repositoryId");
        Matcher matcher = PATTERN_REMOTE_REPO_ID.matcher(repositoryId);
        if (matcher.find()) {
            return new RemoteRepositoryId(Integer.parseInt(matcher.group("partition"), 16), matcher.group("hierarchy"), Integer.parseInt(matcher.group("repository")));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoryId that = (RemoteRepositoryId)o;
        return this.partition == that.partition && this.localId == that.localId && this.hierarchyId.equals(that.hierarchyId);
    }

    @Nonnull
    public String getHierarchyId() {
        return this.hierarchyId;
    }

    public int getLocalId() {
        return this.localId;
    }

    public int getPartition() {
        return this.partition;
    }

    public int hashCode() {
        return Objects.hash(this.hierarchyId, this.partition, this.localId);
    }

    public String toString() {
        return RemoteRepositoryId.format(this.partition, this.hierarchyId, this.localId);
    }
}

