/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.repository;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class RepositoryRefChangeActivityBranchesRequest {
    private final String filterText;
    private final Repository repository;

    private RepositoryRefChangeActivityBranchesRequest(String filterText, Repository repository) {
        this.filterText = filterText;
        this.repository = repository;
    }

    @Nullable
    public String getFilterText() {
        return this.filterText;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder {
        private String filterText;
        private Repository repository;

        public Builder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        public Builder(@Nonnull RepositoryRefChangeActivityBranchesRequest request) {
            Objects.requireNonNull(request, "request");
            this.filterText = request.filterText;
            this.repository = request.repository;
        }

        @Nonnull
        public Builder filterText(@Nullable String value) {
            this.filterText = value;
            return this;
        }

        @Nonnull
        public RepositoryRefChangeActivityBranchesRequest build() {
            return new RepositoryRefChangeActivityBranchesRequest(this.filterText, this.repository);
        }
    }
}

