/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.repository;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class RepositoryRefChangeActivitySearchRequest {
    private final String refId;
    private final Repository repository;

    private RepositoryRefChangeActivitySearchRequest(String refId, Repository repository) {
        this.refId = refId;
        this.repository = repository;
    }

    @Nullable
    public String getRefId() {
        return this.refId;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder {
        private String refId;
        private Repository repository;

        public Builder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        public Builder(@Nonnull RepositoryRefChangeActivitySearchRequest request) {
            Objects.requireNonNull(request, "request");
            this.refId = request.refId;
            this.repository = request.repository;
        }

        @Nonnull
        public Builder refId(@Nullable String value) {
            this.refId = value;
            return this;
        }

        @Nonnull
        public RepositoryRefChangeActivitySearchRequest build() {
            return new RepositoryRefChangeActivitySearchRequest(this.refId, this.repository);
        }
    }
}

