/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.resilience;

import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;

public class CircuitBreakerConfiguration {
    private static final Predicate<Throwable> IGNORE_NONE_PREDICATE = throwable -> false;
    private final String name;
    private final boolean enabled;
    private final float failureThreshold;
    private final int numberOfCallsInHalfOpen;
    private final int windowSize;
    private final int minimumCallsRequired;
    private final Duration slowCallThreshold;
    private final Duration waitInOpenState;
    private final boolean writeStackTraces;
    private final Predicate<Throwable> exceptionsToIgnore;

    private CircuitBreakerConfiguration(Builder builder) {
        this.name = builder.name;
        this.enabled = builder.enabled;
        this.failureThreshold = builder.failureThreshold;
        this.numberOfCallsInHalfOpen = builder.numberOfCallsInHalfOpen;
        this.windowSize = builder.windowSize;
        this.minimumCallsRequired = builder.minimumCallsRequired;
        this.slowCallThreshold = builder.slowCallThreshold;
        this.waitInOpenState = builder.waitInOpenState;
        this.writeStackTraces = builder.writeStackTraces;
        this.exceptionsToIgnore = builder.exceptionsToIgnore;
    }

    @Nonnull
    public Predicate<Throwable> getExceptionsToIgnore() {
        return this.exceptionsToIgnore;
    }

    public float getFailureThreshold() {
        return this.failureThreshold;
    }

    public int getMinimumCallsRequired() {
        return this.minimumCallsRequired;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public int getNumberOfCallsInHalfOpen() {
        return this.numberOfCallsInHalfOpen;
    }

    public float getOrDefaultFailureThreshold(float defaultValue) {
        if (this.failureThreshold > 0.0f && this.failureThreshold <= 100.0f) {
            return this.failureThreshold;
        }
        return defaultValue;
    }

    public int getOrDefaultMinimumCallsRequired(int defaultValue) {
        if (this.minimumCallsRequired > 1) {
            return this.minimumCallsRequired;
        }
        return defaultValue;
    }

    public int getOrDefaultNumberOfCallsInHalfOpen(int defaultValue) {
        if (this.numberOfCallsInHalfOpen > 1) {
            return this.numberOfCallsInHalfOpen;
        }
        return defaultValue;
    }

    @Nonnull
    public Duration getOrDefaultSlowCallThreshold(@Nonnull Duration defaultValue) {
        if (this.slowCallThreshold != null) {
            return this.slowCallThreshold;
        }
        return defaultValue;
    }

    @Nonnull
    public Duration getOrDefaultWaitInOpenState(@Nonnull Duration defaultValue) {
        if (this.waitInOpenState != null) {
            return this.waitInOpenState;
        }
        return defaultValue;
    }

    public int getOrDefaultWindowSize(int defaultValue) {
        if (this.windowSize > 1) {
            return this.windowSize;
        }
        return defaultValue;
    }

    @Nullable
    public Duration getSlowCallThreshold() {
        return this.slowCallThreshold;
    }

    @Nullable
    public Duration getWaitInOpenState() {
        return this.waitInOpenState;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isWriteStackTraces() {
        return this.writeStackTraces;
    }

    public static class Builder
    extends BuilderSupport {
        private final String name;
        private boolean enabled = true;
        private float failureThreshold = -1.0f;
        private int numberOfCallsInHalfOpen = -1;
        private int windowSize = -1;
        private int minimumCallsRequired = -1;
        private Duration slowCallThreshold;
        private Duration waitInOpenState;
        private boolean writeStackTraces = true;
        private Predicate<Throwable> exceptionsToIgnore = IGNORE_NONE_PREDICATE;

        public Builder(@Nonnull String name) {
            this.name = Builder.requireNonBlank((String)name, (String)"name").toLowerCase(Locale.ROOT);
        }

        @Nonnull
        public CircuitBreakerConfiguration build() {
            return new CircuitBreakerConfiguration(this);
        }

        public Builder exceptionsToIgnore(@Nonnull Predicate<Throwable> exceptionsToIgnore) {
            this.exceptionsToIgnore = Objects.requireNonNull(exceptionsToIgnore, "exceptionsToIgnore");
            return this;
        }

        public Builder failureThreshold(float failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public Builder minimumCallsRequired(int minimumCallsRequired) {
            this.minimumCallsRequired = minimumCallsRequired;
            return this;
        }

        public Builder numberOfCallsInHalfOpen(int numberOfCallsInHalfOpen) {
            this.numberOfCallsInHalfOpen = numberOfCallsInHalfOpen;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder slowCallThreshold(@Nonnull Duration slowCallThreshold) {
            this.slowCallThreshold = Objects.requireNonNull(slowCallThreshold, "slowCallThreshold");
            return this;
        }

        public Builder waitInOpenState(@Nonnull Duration waitInOpenState) {
            this.waitInOpenState = Objects.requireNonNull(waitInOpenState, "waitInOpenState");
            return this;
        }

        public Builder windowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Builder writeStackTraces(boolean writeStackTraces) {
            this.writeStackTraces = writeStackTraces;
            return this;
        }
    }
}

