/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secrets;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public enum SecretNamespace {
    ENVIRONMENT("bitbucket.secrets.environment"),
    INTERNAL("bitbucket.secrets.internal"),
    EXTERNAL("bitbucket.secrets.external");

    private final String prefix;

    private SecretNamespace(String prefix) {
        this.prefix = prefix;
    }

    @Nonnull
    public static Optional<SecretNamespace> fromIdentifier(@Nonnull String namespacedIdentifier) {
        Objects.requireNonNull(namespacedIdentifier, "namespacedIdentifier");
        for (SecretNamespace namespace : SecretNamespace.values()) {
            if (!namespacedIdentifier.startsWith(namespace.prefix)) continue;
            return Optional.of(namespace);
        }
        return Optional.empty();
    }

    @Nonnull
    public String apply(@Nonnull String identifier) {
        return this.prefix + "." + Objects.requireNonNull(identifier, "identifier");
    }
}

