/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning;

import com.atlassian.bitbucket.dmz.secretscanning.validation.ValidRe2Regex;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.Update;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;

public class SecretScanningAllowlistSetRequest {
    private static final String ID_ERROR_MESSAGE_TEMPLATE = "{bitbucket.secretscanning.error.invalidid}";
    private static final String NAME_ERROR_MESSAGE_TEMPLATE = "{bitbucket.secretscanning.error.namerequired}";
    private final Long id;
    private final String lineRegex;
    private final String name;
    private final String pathRegex;

    private SecretScanningAllowlistSetRequest(Builder builder) {
        this.id = builder.id;
        this.lineRegex = builder.lineRegex;
        this.name = builder.name;
        this.pathRegex = builder.pathRegex;
    }

    @Nullable
    @NotNull(message="{bitbucket.secretscanning.error.invalidid}", groups={Update.class})
    public @NotNull(message="{bitbucket.secretscanning.error.invalidid}", groups={Update.class}) Long getId() {
        return this.id;
    }

    @Nullable
    @ValidRe2Regex
    public String getLineRegex() {
        return this.lineRegex;
    }

    @Nullable
    @OptionalString(message="{bitbucket.secretscanning.error.namerequired}", groups={Update.class})
    @RequiredString(message="{bitbucket.secretscanning.error.namerequired}", groups={Create.class})
    public String getName() {
        return this.name;
    }

    @Nullable
    @ValidRe2Regex
    public String getPathRegex() {
        return this.pathRegex;
    }

    public static class Builder {
        private Long id;
        private String lineRegex;
        private String name;
        private String pathRegex;

        @Nonnull
        public SecretScanningAllowlistSetRequest build() {
            return new SecretScanningAllowlistSetRequest(this);
        }

        @Nonnull
        public Builder id(@Nullable Long id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder lineRegex(@Nullable String lineRegex) {
            this.lineRegex = lineRegex;
            return this;
        }

        @Nonnull
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder pathRegex(@Nullable String pathRegex) {
            this.pathRegex = pathRegex;
            return this;
        }
    }
}

