/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum SecretScanningExemptRepositoryOrder {
    NAME_ASC("name_asc", "asc"),
    NAME_DESC("name_desc", "desc");

    private final String label;
    private final String order;

    private SecretScanningExemptRepositoryOrder(String label, String order) {
        this.label = label;
        this.order = order;
    }

    @Nonnull
    public static Optional<SecretScanningExemptRepositoryOrder> fromLabel(@Nullable String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        return Arrays.stream(SecretScanningExemptRepositoryOrder.values()).filter(v -> v.getLabel().equals(value.toLowerCase(Locale.US))).findAny();
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    public String getOrder() {
        return this.order;
    }
}

