/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum SecretScanningRuleOrder {
    NAME_ASC("name_asc"),
    NAME_DESC("name_desc");

    private final String label;

    private SecretScanningRuleOrder(String label) {
        this.label = label;
    }

    @Nonnull
    public static Optional<SecretScanningRuleOrder> fromLabel(@Nullable String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        return Arrays.stream(SecretScanningRuleOrder.values()).filter(v -> v.getLabel().equals(value.toLowerCase(Locale.US))).findAny();
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }
}

