/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning.event;

import com.atlassian.bitbucket.dmz.secretscanning.scan.SecretScanResult;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@AsynchronousPreferred
@TransactionAware
public class SecretScanningIncompleteEvent
extends RepositoryEvent {
    private final String commitId;
    private final CommandResult commandResult;
    private final boolean failed;
    private final ApplicationUser initiatingUser;
    private final boolean truncated;

    public SecretScanningIncompleteEvent(@Nullable ApplicationUser initiatingUser, @Nonnull Repository repository, @Nonnull SecretScanResult result, @Nonnull Object source) {
        super(source, repository);
        Objects.requireNonNull(result, "result");
        this.commitId = result.getCommitId();
        this.commandResult = result.getCommandResult();
        this.initiatingUser = initiatingUser;
        this.truncated = result.isTruncated();
        this.failed = result.isScanFailed();
    }

    @Nullable
    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    @Nullable
    public ApplicationUser getInitiatingUser() {
        return this.initiatingUser;
    }
}

