/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.dmz.secretscanning.event.RuleType;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@AsynchronousPreferred
@TransactionAware
@EventName(value="stash.secretscanning.rule.updated")
public class SecretScanningRuleUpdatedEvent
extends ApplicationEvent {
    private final DmzSecretScanningRule newRule;
    private final DmzSecretScanningRule oldRule;
    private final Scope scope;

    public SecretScanningRuleUpdatedEvent(@Nonnull Object source, @Nonnull DmzSecretScanningRule newRule, @Nonnull DmzSecretScanningRule oldRule, @Nonnull Scope scope) {
        super(source);
        this.newRule = Objects.requireNonNull(newRule, "newRule");
        this.oldRule = Objects.requireNonNull(oldRule, "oldRule");
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    public DmzSecretScanningRule getNewRule() {
        return this.newRule;
    }

    public RuleType getNewRuleType() {
        return RuleType.toRuleType(this.newRule);
    }

    public RuleType getOldRuleType() {
        return RuleType.toRuleType(this.oldRule);
    }

    public DmzSecretScanningRule getPreviousRule() {
        return this.oldRule;
    }

    public Scope getScope() {
        return this.scope;
    }
}

