/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning.scan;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SecretLocation {
    private final String commitId;
    private final Integer line;
    private final String path;
    private final Repository repository;
    private final String ruleName;

    public SecretLocation(Repository repository, String commitId, @Nullable Integer line, String path, String ruleName) {
        this.commitId = Objects.requireNonNull(commitId, "commit");
        this.line = line;
        this.path = Objects.requireNonNull(path, "path");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.ruleName = Objects.requireNonNull(ruleName, "ruleName");
    }

    public SecretLocation(Repository repository, String commitId, String path, String ruleName) {
        this(repository, commitId, null, path, ruleName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretLocation that = (SecretLocation)o;
        return Objects.equals(this.line, that.line) && Objects.equals(this.commitId, that.commitId) && Objects.equals(this.path, that.path) && Objects.equals(this.repository, that.repository) && Objects.equals(this.ruleName, that.ruleName);
    }

    public String getCommitId() {
        return this.commitId;
    }

    @Nullable
    public Integer getLine() {
        return this.line;
    }

    public String getPath() {
        return this.path;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public int hashCode() {
        return Objects.hash(this.commitId, this.line, this.path, this.repository, this.ruleName);
    }
}

