/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.server;

import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Objects;

public class AttachDataStoreRequest {
    private final boolean dryRun;
    private final String path;

    private AttachDataStoreRequest(Builder builder) {
        this.dryRun = builder.dryRun;
        this.path = builder.path;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public static class Builder
    extends BuilderSupport {
        private final String path;
        private boolean dryRun;

        public Builder(@Nonnull Path path) {
            this.path = Objects.requireNonNull(path, "path").toAbsolutePath().toString();
        }

        public Builder(@Nonnull String path) {
            this.path = Builder.requireNonBlank((String)path, (String)"path");
        }

        @Nonnull
        public AttachDataStoreRequest build() {
            return new AttachDataStoreRequest(this);
        }

        @Nonnull
        public Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }
    }
}

