/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.signature.verification;

import com.atlassian.bitbucket.dmz.signature.verification.SignatureState;
import com.atlassian.bitbucket.dmz.signature.verification.SignatureVerificationPublicKey;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

public class SignatureVerificationResult {
    private final ApplicationUser owner;
    private final SignatureVerificationPublicKey publicKey;
    private final Map<String, String> signatureMetadata;
    private final SignatureState signatureState;
    private final String signatureType;

    public SignatureVerificationResult(Builder builder) {
        this.signatureState = Objects.requireNonNull(builder.signatureState, "signatureState");
        this.owner = builder.owner;
        this.signatureMetadata = builder.signatureMetadata.build();
        this.signatureType = builder.signatureType;
        this.publicKey = builder.signatureVerificationPublicKey;
    }

    @Nullable
    public ApplicationUser getOwner() {
        return this.owner;
    }

    @Nonnull
    public Map<String, String> getSignatureMetadata() {
        return this.signatureMetadata;
    }

    @Nonnull
    public SignatureState getSignatureState() {
        return this.signatureState;
    }

    @Nullable
    public String getSignatureType() {
        return this.signatureType;
    }

    @Nullable
    public SignatureVerificationPublicKey getVerificationPublicKey() {
        return this.publicKey;
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, String> signatureMetadata;
        private final SignatureState signatureState;
        private ApplicationUser owner;
        private String signatureType;
        private SignatureVerificationPublicKey signatureVerificationPublicKey;

        public Builder(@Nonnull SignatureState signatureState) {
            this.signatureState = Objects.requireNonNull(signatureState, "signatureState");
            this.signatureMetadata = ImmutableMap.builder();
        }

        @Nonnull
        public SignatureVerificationResult build() {
            return new SignatureVerificationResult(this);
        }

        @Nonnull
        public Builder owner(@Nonnull ApplicationUser owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            return this;
        }

        @Nonnull
        public Builder signatureMetadata(@Nonnull Map<String, String> signatureMetadata) {
            this.signatureMetadata.putAll(Objects.requireNonNull(signatureMetadata, "signatureMetadata"));
            return this;
        }

        @Nonnull
        public Builder signatureType(@Nonnull String signatureType) {
            this.signatureType = Objects.requireNonNull(signatureType, "signatureType");
            return this;
        }

        @Nonnull
        public Builder verificationPublicKey(@Nonnull SignatureVerificationPublicKey signatureVerificationPublicKey) {
            this.signatureVerificationPublicKey = Objects.requireNonNull(signatureVerificationPublicKey, "signatureVerificationPublicKey");
            return this;
        }
    }
}

