/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.ssh;

import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.util.Objects;

@AsynchronousPreferred
public class SshAuthenticationSuccessEvent
extends AuthenticationSuccessEvent {
    private final String authenticationMethod;
    private final PublicKey publicKey;

    public SshAuthenticationSuccessEvent(@Nonnull Object source, @Nonnull PublicKey publicKey, @Nullable String tokenDetails, @Nonnull ApplicationUser user) {
        super(source, Objects.requireNonNull(user, "user").getName(), "ssh", tokenDetails);
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
        this.authenticationMethod = SshAuthenticationSuccessEvent.getAuthenticationMethod(user);
    }

    @Nonnull
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Nonnull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    private static String getAuthenticationMethod(ApplicationUser user) {
        if (user.getType() == UserType.NORMAL) {
            return "user-key";
        }
        return "access-key";
    }
}

